/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.HybridStructureCalculator;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.calc.NNParameters;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.struct.DefaultNAHybridStructure;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionalMeltingPointCalculator
extends AbstractParameterHolder
implements HybridStructureCalculator,
MeltingPointCalculator {
    protected static final float dGInit = 1960.0f;
    protected static final byte EXTEND = 0;
    protected static final byte F_GAP = 1;
    protected static final byte S_GAP = 2;
    protected NNParameters NNParams;
    protected float Naconc;
    protected float C;
    protected float RlnC;
    protected boolean debug = false;
    protected boolean debug2 = false;
    protected boolean debug3 = false;
    boolean debugtrace = false;
    final boolean ends = true;
    protected float Tm;
    protected NucleotideSequence seq1;
    protected NucleotideSequence seq2;
    protected NAHybridStructure x;
    protected byte[] firstB;
    protected byte[] secondB;
    protected float[][][] dG;
    protected boolean[][][] usedPositions;
    protected float[][][][] ddG;
    protected StringBuffer[] traces = new StringBuffer[2];
    protected int[] positions = new int[4];
    protected int phosphates;
    protected float pairSaltdG;
    float[][][][] ddG0;
    static int count = 0;
    static int count2 = 0;

    @Override
    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("SODIUM_CONCENTRATION", "1");
        p.put("PROBE_CONCENTRATION", "1000");
        return p;
    }

    public static char byteToBase(byte b) {
        switch (b) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
            case 5: {
                return '$';
            }
            case 4: {
                return '-';
            }
        }
        throw new UnsupportedOperationException("Unrecognized base symbol: " + b);
    }

    protected static final byte basecode(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case '$': {
                return 5;
            }
            case '-': {
                return 4;
            }
        }
        throw new UnsupportedOperationException("Unrecognized base symbol: " + c);
    }

    protected static byte[] getByteArray(String seq) {
        byte[] array = new byte[seq.length() + 2];
        array[0] = 5;
        array[array.length - 1] = 5;
        for (int i = 1; i < array.length - 1; ++i) {
            array[i] = FractionalMeltingPointCalculator.basecode(seq.charAt(i - 1));
        }
        return array;
    }

    protected static boolean isValid(NucleotideSequence seq1, NucleotideSequence seq2) {
        return seq1.getType() == 0 && seq2.getType() == 0;
    }

    public FractionalMeltingPointCalculator(NNParameters params) {
        this.NNParams = params;
        this.parameters = this.getDefaultParameters();
        this.readParameters();
    }

    void readParameters() {
        this.Naconc = Float.parseFloat((String)this.parameters.get("SODIUM_CONCENTRATION"));
        this.C = (float)((double)Float.parseFloat((String)this.parameters.get("PROBE_CONCENTRATION")) * 1.0E-9);
        this.RlnC = (float)(1.9891173839569092 * Math.log((double)this.C / 4.0));
        this.pairSaltdG = -0.114f * (float)this.phosphates / 2.0f * (float)Math.log(this.Naconc);
        this.ddG0 = new float[6][6][6][6];
        for (byte x1 = 0; x1 < 6; x1 = (byte)((byte)(x1 + 1))) {
            for (byte x2 = 0; x2 < 6; x2 = (byte)((byte)(x2 + 1))) {
                for (byte y1 = 0; y1 < 6; y1 = (byte)((byte)(y1 + 1))) {
                    for (byte y2 = 0; y2 < 6; y2 = (byte)(y2 + 1)) {
                        this.ddG0[x1][x2][y1][y2] = this.ddG(x1, x2, y1, y2, 0.0f);
                    }
                }
            }
        }
    }

    @Override
    public void addParameters(Map<String, String> m) {
        super.addParameters(m);
        this.readParameters();
    }

    @Override
    public void setParameters(Map<String, String> m) {
        super.addParameters(m);
        this.readParameters();
    }

    @Override
    public float getMeltingPoint(NucleotideSequence seq11, NucleotideSequence seq21, NAHybridStructure struct) {
        if (this.seq1 == seq11 && this.seq2 == seq21 && this.x == struct) {
            return this.Tm;
        }
        this.seq1 = seq11;
        this.seq2 = seq21;
        this.x = struct;
        return this.q(struct) - 273.15f;
    }

    @Override
    public NAHybridStructure calculateHybridStructure(NucleotideSequence s1, NucleotideSequence s2) {
        this.seq1 = s1;
        this.seq2 = s2;
        this.doDinkelbach(this.seq1.seqString(), SequenceHandler.getRev((Sequence)this.seq2));
        return this.x;
    }

    float ddG(byte x1, byte x2, byte y1, byte y2) {
        return this.ddG[x1][x2][y1][y2];
    }

    float ddG(byte x1, byte x2, byte y1, byte y2, float t) {
        float dS = this.NNParams.getS(x1, x2, y1, y2);
        float dH = this.NNParams.getH(x1, x2, y1, y2);
        if (dS == Float.MAX_VALUE || dH == Float.MAX_VALUE) {
            return Float.POSITIVE_INFINITY;
        }
        return dH - t * dS + this.pairSaltdG;
    }

    float getHighestCell(int[] pos) {
        float maxvalue = -3.4028235E38f;
        if (this.dG == null) {
            return maxvalue;
        }
        for (int n = 0; n < 2; ++n) {
            int i = this.dG.length - 1;
            int j = this.dG[i].length - 1;
            while (i > 0 && j > 0) {
                float G3;
                float G2;
                float G1 = this.usedPositions[i][j][0] ? 0.0f : this.dG[i][j][0];
                float Tm1 = Math.max(G1, Math.max(G2 = this.usedPositions[i][j][1] ? 0.0f : this.dG[i][j][1], G3 = this.usedPositions[i][j][2] ? 0.0f : this.dG[i][j][2]));
                if (Tm1 > maxvalue) {
                    maxvalue = Tm1;
                    pos[0] = i;
                    pos[1] = j;
                    pos[2] = G1 >= G2 && G1 >= G3 ? 0 : (G2 >= G3 ? 1 : 2);
                }
                if (n == 0) {
                    --i;
                    continue;
                }
                --j;
            }
        }
        if (this.debug) {
            System.out.println("Pos: " + pos[0] + ", " + pos[1] + ", " + pos[2] + ": " + this.dG[pos[0]][pos[1]][pos[2]]);
        }
        return maxvalue;
    }

    protected byte getType(int i, int j) {
        float G1 = this.dG[i][j][0];
        float G2 = this.dG[i][j][1];
        float G3 = this.dG[i][j][2];
        if (G1 >= G2 && G1 >= G3) {
            return 0;
        }
        if (G2 >= G3) {
            return 1;
        }
        return 2;
    }

    protected int traceBack(int i, int j, float t, int p) {
        this.traces[0] = new StringBuffer();
        this.traces[1] = new StringBuffer();
        this.positions = new int[4];
        this.positions[1] = i - 1;
        this.positions[3] = j - 1;
        this.traceBack(i, j, this.getType(i, j), t, p);
        return Math.max(this.positions[1] - this.positions[0] - 1, this.positions[2] - this.positions[1] - 1);
    }

    void traceBack(int i, int j, int type, float t, int p) {
        if (i < 1 || j < 1) {
            this.positions[0] = i;
            this.positions[2] = j;
            return;
        }
        int x1 = i > 1 ? this.firstB[i - 2] : 4;
        int y1 = j > 1 ? this.secondB[j - 2] : 4;
        byte x2 = this.firstB[i - 1];
        byte y2 = this.secondB[j - 1];
        float dG1 = this.dG[i][j][0];
        float dG2 = this.dG[i][j][1];
        float dG3 = this.dG[i][j][2];
        if (this.debugtrace) {
            System.out.println("Traceback: " + i + ", " + j + ", " + type + ": " + dG1 + ", " + dG2 + ", " + dG3);
        }
        switch (type) {
            case 0: {
                float G1 = this.dG[i - 1][j - 1][0] - this.ddG[x1][x2][y1][y2];
                float G2 = this.dG[i - 1][j - 1][1] - this.ddG[4][x2][y1][y2];
                if (G1 == dG1) {
                    this.traceBack(i - 1, j - 1, 0, t, p);
                } else if (G2 == dG1) {
                    this.traceBack(i - 1, j - 1, 1, t, p);
                } else {
                    this.traceBack(i - 1, j - 1, 2, t, p);
                }
                this.traces[0].append(FractionalMeltingPointCalculator.byteToBase(x2));
                this.traces[1].append(FractionalMeltingPointCalculator.byteToBase(y2));
                break;
            }
            case 1: {
                float G1 = this.dG[i][j - 1][0] - this.ddG[x2][4][y1][y2];
                float G2 = this.dG[i][j - 1][1] - this.ddG[4][4][y1][y2];
                if (G1 == dG2) {
                    this.traceBack(i, j - 1, 0, t, p);
                } else {
                    this.traceBack(i, j - 1, 1, t, p);
                }
                this.traces[0].append('-');
                this.traces[1].append(FractionalMeltingPointCalculator.byteToBase(y2));
                break;
            }
            case 2: {
                float G1 = this.dG[i - 1][j][0] - this.ddG[x1][x2][y2][4];
                float G2 = this.dG[i - 1][j][2] - this.ddG[x1][x2][4][4];
                if (G1 == dG3) {
                    this.traceBack(i - 1, j, 0, t, p);
                } else {
                    this.traceBack(i - 1, j, 2, t, p);
                }
                this.traces[0].append(FractionalMeltingPointCalculator.byteToBase(x2));
                this.traces[1].append('-');
            }
        }
        if (this.debugtrace) {
            System.out.println("Traceback: " + this.traces[0] + ", " + this.traces[1] + ": ");
        }
    }

    protected Alignment getNextAlignment(float t) {
        int[] pos = new int[3];
        float deltaG = this.getHighestCell(pos);
        if (this.debug) {
            System.out.println("dG: " + this.dG[pos[0]][pos[1]][pos[2]]);
        }
        if (deltaG == -3.4028235E38f) {
            return null;
        }
        for (int i = 0; i < this.usedPositions[pos[0]][pos[1]].length; ++i) {
            this.usedPositions[pos[0]][pos[1]][i] = true;
        }
        int length = this.traceBack(pos[0], pos[1], t, this.phosphates);
        if (length < 0) {
            throw new UnsupportedOperationException("Length below zero in traceBack()");
        }
        if (length == 0) {
            return null;
        }
        if (this.debug) {
            System.out.println("Traces:\t" + this.positions[0] + ", " + this.positions[1] + ", " + this.positions[2] + ", " + this.positions[3]);
        }
        if (this.debug) {
            System.out.println("  " + this.traces[0]);
        }
        if (this.debug) {
            System.out.println("  " + this.traces[1]);
        }
        int[] l1 = this.leadingGapsAndTerms(this.traces[0]);
        int[] l2 = this.leadingGapsAndTerms(this.traces[1]);
        int[] t1 = this.trailingGapsAndTerms(this.traces[0]);
        int[] t2 = this.trailingGapsAndTerms(this.traces[1]);
        int ba1 = l1[0] + l1[1];
        int ea1 = t1[0] + t1[1];
        int ba2 = l2[0] + l2[1];
        int ea2 = t2[0] + t2[1];
        int begAdjust = Math.max(ba1, ba2);
        int endAdjust = -Math.max(ea1, ea2);
        int s1 = this.positions[0] + Math.max(ba2, l1[1]);
        int e1 = this.positions[1] - Math.max(ea2, t1[1]);
        int s2 = this.positions[2] + Math.max(ba1, l2[1]);
        int e2 = this.positions[3] - Math.max(ea1, t2[1]);
        if (this.debug) {
            System.out.println("Traces:\t" + s1 + ", " + e1 + ", " + s2 + ", " + e2);
        }
        return new SimpleAlignment(s1, e1, this.traces[0].substring(begAdjust, this.traces[0].length() + endAdjust), s2, e2, this.traces[1].substring(begAdjust, this.traces[1].length() + endAdjust));
    }

    int[] leadingGapsAndTerms(CharSequence str) {
        int g = 0;
        int t = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '-') {
                ++g;
                continue;
            }
            if (c != '$') break;
            ++t;
        }
        return new int[]{g, t};
    }

    int[] trailingGapsAndTerms(CharSequence str) {
        int g = 0;
        int t = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c == '-') {
                ++g;
                continue;
            }
            if (c != '$') break;
            ++t;
        }
        return new int[]{g, t};
    }

    void calculateTable(float t) {
        int c;
        if (t == 0.0f) {
            this.ddG = this.ddG0;
        } else {
            this.ddG = new float[6][6][6][6];
            for (byte x1 = 0; x1 < 6; x1 = (byte)((byte)(x1 + 1))) {
                for (byte x2 = 0; x2 < 6; x2 = (byte)((byte)(x2 + 1))) {
                    for (byte y1 = 0; y1 < 6; y1 = (byte)((byte)(y1 + 1))) {
                        for (byte y2 = 0; y2 < 6; y2 = (byte)(y2 + 1)) {
                            this.ddG[x1][x2][y1][y2] = this.ddG(x1, x2, y1, y2, t);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.dG.length; ++i) {
            for (c = 0; c < this.dG[0][0].length; ++c) {
                this.dG[i][0][c] = -1960.0f;
            }
        }
        for (int j = 0; j < this.dG[0].length; ++j) {
            for (c = 0; c < this.dG[0][0].length; ++c) {
                this.dG[0][j][c] = -1960.0f;
            }
        }
        for (int i = 1; i < this.dG.length; ++i) {
            byte i1 = i == 1 ? (byte)4 : this.firstB[i - 2];
            byte i2 = this.firstB[i - 1];
            for (int j = 1; j < this.dG[0].length; ++j) {
                byte j1 = j == 1 ? (byte)4 : this.secondB[j - 2];
                byte j2 = this.secondB[j - 1];
                this.calculateCell(i, j, i1, i2, j1, j2);
            }
        }
    }

    protected void calculateCell(int i, int j, byte i1, byte i2, byte j1, byte j2) {
        float G1 = this.dG[i - 1][j - 1][0] - this.ddG[i1][i2][j1][j2];
        float G2 = this.dG[i - 1][j - 1][1] - this.ddG[4][i2][j1][j2];
        float G3 = this.dG[i - 1][j - 1][2] - this.ddG[i1][i2][4][j2];
        this.dG[i][j][0] = G1 >= G2 && G1 >= G3 ? G1 : (G2 >= G3 ? G2 : G3);
        this.dG[i][j][1] = i == 1 || i == this.firstB.length - 1 ? Float.NEGATIVE_INFINITY : ((G1 = this.dG[i][j - 1][0] - this.ddG[i2][4][j1][j2]) >= (G2 = this.dG[i][j - 1][1] - this.ddG[4][4][j1][j2]) ? G1 : G2);
        this.dG[i][j][2] = j == 1 || j == this.secondB.length - 1 ? Float.NEGATIVE_INFINITY : ((G1 = this.dG[i - 1][j][0] - this.ddG[i1][i2][j2][4]) >= (G2 = this.dG[i - 1][j][2] - this.ddG[i1][i2][4][4]) ? G1 : G2);
    }

    NAHybridStructure solveForMax(float q) {
        this.dG = new float[this.firstB.length + 1][this.secondB.length + 1][4];
        this.calculateTable(q);
        this.usedPositions = new boolean[this.dG.length][this.dG[0].length][this.dG[0][0].length];
        Alignment la = this.getNextAlignment(q);
        if (la == null) {
            return null;
        }
        return new DefaultNAHybridStructure(la, this.secondB.length - 2);
    }

    void doDinkelbach(String s1, String s2) {
        if (this.debug3) {
            System.out.println(s1);
            System.out.println(s2);
        }
        this.firstB = FractionalMeltingPointCalculator.getByteArray(s1);
        this.secondB = FractionalMeltingPointCalculator.getByteArray(s2);
        this.phosphates = s1.length() + s2.length() - 2;
        float e = 0.01f;
        float q = 0.0f;
        boolean done = false;
        int i = 1;
        while (!done) {
            float g;
            StringBuffer str2;
            StringBuffer[] strs;
            StringBuffer str1;
            float f;
            float F;
            if (this.debug) {
                System.out.println(i + ", q = " + q);
            }
            this.x = this.solveForMax(q);
            if (this.x == null) {
                if (this.debug) {
                    System.out.println("No significant alignment found");
                }
                done = true;
                this.Tm = -273.15f;
                break;
            }
            if (this.debug) {
                System.out.println("A:  " + this.x.getFirstString());
                System.out.println("B:  " + SequenceHandler.getRev((String)this.x.getSecondString()));
            }
            if (Math.abs(F = this.F(f = this.f(str1 = (strs = this.attachDanglingEnds(this.x))[0], str2 = strs[1].reverse()), q, g = this.g(str1, str2))) < e) {
                this.Tm = q - 273.15f;
                done = true;
            } else {
                float q2 = f / g;
                if (q2 < q) {
                    done = true;
                } else {
                    q = q2;
                }
                ++i;
            }
            if (i <= 50) continue;
            done = true;
        }
    }

    protected static float getSaltdS(float Naconc, int length) {
        float factor = 0.368f;
        return factor * (float)length / 2.0f * (float)Math.log(Naconc);
    }

    float f(CharSequence str1, CharSequence str2) {
        float dH = this.NNParams.getInitH();
        byte x1 = FractionalMeltingPointCalculator.basecode(str1.charAt(0));
        byte y1 = FractionalMeltingPointCalculator.basecode(str2.charAt(0));
        for (int i = 1; i < str1.length(); ++i) {
            byte x2 = FractionalMeltingPointCalculator.basecode(str1.charAt(i));
            byte y2 = FractionalMeltingPointCalculator.basecode(str2.charAt(i));
            float ddH = this.NNParams.getH(x1, x2, y1, y2);
            if (this.debug) {
                System.out.println(this.doublet(x1, x2, y1, y2) + " dH: " + ddH);
            }
            dH += ddH;
            x1 = x2;
            y1 = y2;
        }
        return -dH;
    }

    float g(CharSequence str1, CharSequence str2) {
        float dS = this.NNParams.getInitS();
        byte x1 = FractionalMeltingPointCalculator.basecode(str1.charAt(0));
        byte y1 = FractionalMeltingPointCalculator.basecode(str2.charAt(0));
        for (int i = 1; i < str1.length(); ++i) {
            byte x2 = FractionalMeltingPointCalculator.basecode(str1.charAt(i));
            byte y2 = FractionalMeltingPointCalculator.basecode(str2.charAt(i));
            float ddS = this.NNParams.getS(x1, x2, y1, y2);
            if (this.debug) {
                System.out.println(this.doublet(x1, x2, y1, y2) + " dS: " + ddS);
            }
            dS += ddS;
            x1 = x2;
            y1 = y2;
        }
        if (this.x == null) {
            throw new RuntimeException("X unexpectedly null");
        }
        float saltDS = FractionalMeltingPointCalculator.getSaltdS(this.Naconc, this.x.getFirstString().length());
        return -(dS + saltDS + this.RlnC);
    }

    public int getCount() {
        return count;
    }

    public int getCount2() {
        return count2;
    }

    float q(NAHybridStructure x1) {
        StringBuffer[] strs = this.attachDanglingEnds(x1);
        StringBuffer str1 = strs[0];
        StringBuffer str2 = strs[1].reverse();
        if (this.debug) {
            System.out.println(str1);
            System.out.println(str2);
        }
        float f = this.f(str1, str2);
        float g = this.g(str1, str2);
        float q = f / g;
        if (this.debug) {
            System.out.println("f(x): " + f);
            System.out.println("g(x): " + g);
            System.out.println("q(x): " + q);
        }
        return q;
    }

    float F(float f, float q, float g) {
        return f - q * g;
    }

    float F(float q, NAHybridStructure x1) {
        StringBuffer[] strs = this.attachDanglingEnds(x1);
        StringBuffer str1 = strs[0];
        StringBuffer str2 = strs[1].reverse();
        float f = this.f(str1, str2);
        float g = this.g(str1, str2);
        float F = f - q * g;
        if (this.debug3) {
            System.out.println("  f(x): " + f);
            System.out.println("  g(x): " + g);
            System.out.println("  F(q,x): " + F);
        }
        return F;
    }

    StringBuffer[] attachDanglingEnds(NAHybridStructure struct) {
        StringBuffer str1 = new StringBuffer(struct.getFirstString());
        StringBuffer str2 = new StringBuffer(struct.getSecondString());
        int s1 = struct.getFirstStart();
        int s2 = struct.getSecondStart();
        int e1 = struct.getFirstEnd();
        int e2 = struct.getSecondEnd();
        if (this.debug) {
            System.out.println("Struct positions (" + this.seq1.length() + ", " + this.seq2.length() + "): " + s1 + "\t" + e1 + "\t" + s2 + "\t" + e2);
            System.out.println("Trace positions: " + this.positions[0] + ", " + this.positions[1] + ", " + this.positions[2] + ", " + this.positions[3]);
        }
        if (s1 == 1 && e2 == this.seq2.length()) {
            str1.insert(0, '$');
            str2.append('$');
        } else if (s1 == 1) {
            str1.insert(0, '$');
            str2.append(this.seq2.seqString().charAt(e2));
        } else if (e2 == this.seq2.length()) {
            str1.insert(0, this.seq1.seqString().charAt(s1 - 2));
            str2.append('$');
        }
        if (s2 == 1 && e1 == this.seq1.length()) {
            str2.insert(0, '$');
            str1.append('$');
        } else if (s2 == 1) {
            str2.insert(0, '$');
            str1.append(this.seq1.seqString().charAt(e1));
        } else if (e1 == this.seq1.length()) {
            str2.insert(0, this.seq2.seqString().charAt(s2 - 2));
            str1.append('$');
        }
        return new StringBuffer[]{str1, str2};
    }

    protected String doublet(byte x1, byte x2, byte y1, byte y2) {
        return FractionalMeltingPointCalculator.byteToBase(x1) + "" + FractionalMeltingPointCalculator.byteToBase(x2) + "/" + FractionalMeltingPointCalculator.byteToBase(y1) + "" + FractionalMeltingPointCalculator.byteToBase(y2);
    }

    protected void debugResultMatrix() {
        if (this.debug2) {
            for (int i = 0; i < this.dG.length; ++i) {
                for (int j = 0; j < this.dG[i].length; ++j) {
                    System.out.print(this.dG[i][j][0]);
                    for (int k = 1; k < 3; ++k) {
                        System.out.print(", " + this.dG[i][j][k]);
                    }
                    System.out.print("\t");
                }
                System.out.println();
            }
        }
    }

    @Override
    public float getMeltingPoint(NucleotideSequence seq) {
        SimpleNucleotideSequence ns2 = new SimpleNucleotideSequence("S1", NucleotideSequenceHandler.getRevComp((NucleotideSequence)seq));
        DefaultNAHybridStructure nst = new DefaultNAHybridStructure((Sequence)seq, 1, seq.length(), (Sequence)ns2, 1, ns2.length());
        return this.getMeltingPoint(seq, (NucleotideSequence)ns2, (NAHybridStructure)nst);
    }
}

