/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.moltools.design.calc.SmithWatermanCalculator;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.Property;
import org.moltools.design.services.IntraAnalysis;
import org.moltools.lib.seq.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmithWatermanMatchAnalysis
implements IntraAnalysis {
    public static final String PROPERTY_MATCH = "swmatch";
    protected Map<String, String> matchSeqs;
    protected Map<String, Float> maxScores;
    protected SmithWatermanCalculator swc;

    public SmithWatermanMatchAnalysis() {
    }

    public SmithWatermanMatchAnalysis(Map<String, String> matchSeqs, SmithWatermanCalculator swc) {
        this.matchSeqs = matchSeqs;
        this.swc = swc;
    }

    @Override
    public List<Property> analyze(Object object) {
        String matchSeq;
        Sequence seq = (Sequence)object;
        ArrayList<Property> props = new ArrayList<Property>();
        if (this.maxScores == null) {
            this.maxScores = new HashMap<String, Float>();
            for (String key : this.matchSeqs.keySet()) {
                matchSeq = this.matchSeqs.get(key);
                this.maxScores.put(key, new Float(this.swc.getScore(matchSeq, matchSeq)));
            }
        }
        for (String key : this.matchSeqs.keySet()) {
            matchSeq = this.matchSeqs.get(key);
            this.swc.doAlignment(seq.seqString(), matchSeq);
            int matchScore = this.swc.getHighestCell(new int[2]);
            float maxScore = this.maxScores.get(key).floatValue();
            Float percentScore = new Float((float)matchScore / maxScore);
            props.add(new SimpleProperty(PROPERTY_MATCH, new DefaultKeyValue((Object)key, (Object)percentScore), true));
        }
        return props;
    }

    public SmithWatermanCalculator getSWCalculator() {
        return this.swc;
    }

    public void setSWCalculator(SmithWatermanCalculator swc) {
        this.swc = swc;
    }

    public Map<String, String> getMatchSeqs() {
        return this.matchSeqs;
    }

    public void setMatchSeqs(Map<String, String> matchSeqs) {
        this.matchSeqs = new HashMap<String, String>(matchSeqs);
    }
}

