/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import net.sf.apptools.ActivePlugInListener;
import net.sf.apptools.CoreEngine;
import net.sf.apptools.Platform;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.ActionSetListener;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.console.ActionInterpreter;
import net.sf.apptools.console.Command;
import net.sf.apptools.console.CommandParser;
import net.sf.apptools.console.CommandSet;
import net.sf.apptools.console.DefaultCommand;
import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DefaultDataHolder;
import net.sf.apptools.data.PlugInClassListSelectionDescriptor;
import net.sf.apptools.data.PlugInListSelectionDescriptor;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInLoader;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.plugin.PlugInManagerListener;
import net.sf.apptools.prefs.EntryDescriptor;
import net.sf.apptools.prefs.FileEntryDescriptor;
import net.sf.apptools.prefs.PreferencesEntryTree;
import net.sf.apptools.task.Task;
import net.sf.apptools.task.TaskListener;
import net.sf.apptools.ui.PlatformUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlatform
implements Platform,
PreferenceChangeListener,
PlugInManagerListener {
    static Log log = LogFactory.getLog(DefaultPlatform.class);
    static final String PREF_HOME_DIR = "HOME_DIR";
    static final String PREF_AUTO_ACTIVATE_FILE = "AUTO_ACTIVATE_FILE";
    public static final EntryDescriptor HOME_DIR = new FileEntryDescriptor("HOME_DIR", PlatformTexts.getString("Platform.PREF_NAME_HOME_DIR"), PlatformTexts.getString("Platform.PREF_DESC_HOME_DIR"), "", 1, true);
    public static final EntryDescriptor AUTO_FILE = new FileEntryDescriptor("AUTO_ACTIVATE_FILE", PlatformTexts.getString("Platform.PREF_NAME_PLUGIN_FILE"), PlatformTexts.getString("Platform.PREF_DESC_PLUGIN_FILE"), "plugins/autoact.txt", 1, false);
    public static final EntryDescriptor[] PREF_ENTRIES = new EntryDescriptor[]{AUTO_FILE, HOME_DIR};
    protected PreferencesEntryTree entryTree;
    public CoreEngine coreEngine;
    protected Map<ActivePlugIn, List<ActionSet>> quickActionSets = new WeakHashMap<ActivePlugIn, List<ActionSet>>();
    protected List<ActionSet> actionGroups = new ArrayList<ActionSet>();
    protected Map<ActionSet, ActivePlugIn> actionEncapsulations = new WeakHashMap<ActionSet, ActivePlugIn>();
    protected Map<ActionSet, ActivePlugIn> quickActionEncapsulations = new WeakHashMap<ActionSet, ActivePlugIn>();
    protected File autoActivateFile;
    protected File homePath;
    protected List<ActionSetListener> actionGroupListeners = new ArrayList<ActionSetListener>();
    protected List<ActivePlugInListener> activePlugInListeners = new ArrayList<ActivePlugInListener>();
    protected List<TaskListener> taskListeners = new ArrayList<TaskListener>();
    protected PlatformUI ui;
    protected CommandSet commands;
    protected ActionInterpreter interpreter;
    protected CommandParser parser;

    public DefaultPlatform(CoreEngine core) {
        this.coreEngine = core;
        this.interpreter = new ActionInterpreter();
        this.commands = new CommandSet();
        this.parser = new CommandParser(this.commands, this.interpreter);
        this.entryTree = new PreferencesEntryTree(this.coreEngine.getUserPreferences().name());
        this.entryTree.getRootNode().addEntries(this.coreEngine.getPreferencesEntries());
        this.addPreferenceEntries(PREF_ENTRIES, "", this);
        this.setHomeDirectory(this.coreEngine.getUserPreferences().get(HOME_DIR.getKey(), HOME_DIR.getDefault()));
        this.setAutoActivateFile(this.coreEngine.getUserPreferences().get(AUTO_FILE.getKey(), AUTO_FILE.getDefault()));
        log.info((Object)(HOME_DIR.getKey() + " = " + this.homePath));
        log.info((Object)(AUTO_FILE.getKey() + " = " + this.autoActivateFile));
        this.getPlugInManager().addListener((PlugInManagerListener)this);
        this.setupActions();
    }

    protected void setupActions() {
        String quitCaption = PlatformTexts.getString("Platform.CAPTION_QUIT");
        String quitTooltip = PlatformTexts.getString("Platform.TOOLTIP_QUIT");
        AbstractUserAction quit = new AbstractUserAction(quitCaption, quitTooltip){

            public void execute() {
                DefaultPlatform.this.close();
            }
        };
        String activatePluginsCaption = PlatformTexts.getString("Platform.CAPTION_ACT_PLUGIN");
        String activatePluginsTooltip = PlatformTexts.getString("Platform.TOOLTIP_ACT_PLUGIN");
        AbstractUserAction activatePlugins = new AbstractUserAction(activatePluginsCaption, activatePluginsTooltip){

            public void execute() {
                DefaultPlatform.this.activatePlugins();
            }
        };
        String deactivatePluginsCaption = PlatformTexts.getString("Platform.CAPTION_DEACT_PLUGIN");
        String deactivatePluginsTooltip = PlatformTexts.getString("Platform.TOOLTIP_DEACT_PLUGIN");
        AbstractUserAction deactivatePlugins = new AbstractUserAction(deactivatePluginsCaption, deactivatePluginsTooltip){

            public void execute() {
                DefaultPlatform.this.deActivatePlugins();
            }
        };
        AbstractUserAction exitConsole = new AbstractUserAction(PlatformTexts.getString("Platform.CAPTION_EXIT_UI"), PlatformTexts.getString("Platform.TOOLTIP_EXIT_UI")){

            public void execute() {
                DefaultPlatform.this.getUI().exit();
            }
        };
        AbstractUserAction listCommands = new AbstractUserAction(PlatformTexts.getString("Platform.CAPTION_LIST_COMMANDS"), PlatformTexts.getString("Platform.TOOLTIP_LIST_COMMANDS")){

            public void execute() {
                DefaultPlatform.this.getUI().sendMessage(CommandParser.getCommandList(DefaultPlatform.this.commands.getCommands(), 0), PlatformTexts.getString("Platform.TITLE_LIST_COMMANDS"), (byte)0);
            }
        };
        this.addActionSet(new ActionSet(new UserAction[]{exitConsole, listCommands}, null, null));
        this.addActionSet(new ActionSet(new UserAction[]{quit}, PlatformTexts.getString("Platform.MENU_FILE"), null, -1));
        this.addActionSet(new ActionSet(new UserAction[]{activatePlugins, deactivatePlugins}, PlatformTexts.getString("Platform.MENU_OPTIONS"), null, 900));
    }

    @Override
    public PlatformUI getUI() {
        return this.ui;
    }

    @Override
    public boolean setUI(PlatformUI newUI) {
        try {
            log.debug((Object)("setUI called with " + (newUI == null ? "null" : newUI.getClass().getName())));
            if (this.ui != null) {
                this.ui.exit();
            }
            this.ui = newUI;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void addPreferenceEntries(EntryDescriptor[] entries, String nodePath, PreferenceChangeListener listener) {
        PreferencesEntryTree.Node n;
        String path = nodePath.toLowerCase();
        PreferencesEntryTree.Node node = n = path.equals("") ? this.entryTree.getRootNode() : this.entryTree.getNode(path);
        if (n == null) {
            n = this.entryTree.createNode(path);
        }
        n.addEntries(entries);
        Preferences uprefs = this.coreEngine.getUserPreferences();
        if (uprefs == null) {
            throw new UnsupportedOperationException("Can't run platform without preferences");
        }
        Preferences uNode = null;
        uNode = uprefs.node(path);
        if (listener != null) {
            uNode.addPreferenceChangeListener(listener);
        }
        block5: for (int i = 0; i < entries.length; ++i) {
            EntryDescriptor e = entries[i];
            String key = e.getKey();
            String defValue = e.getDefault();
            switch (e.getType()) {
                case 1: {
                    try {
                        if (!Arrays.asList(uNode.keys()).contains(key)) {
                            uNode.put(key, defValue);
                            uNode.flush();
                            continue block5;
                        }
                        if (listener == null) continue block5;
                        listener.preferenceChange(new PreferenceChangeEvent(uNode, key, uNode.get(key, defValue)));
                        continue block5;
                    }
                    catch (BackingStoreException e1) {
                        uNode.put(key, defValue);
                    }
                }
            }
        }
    }

    @Override
    public void removePreferenceEntries(EntryDescriptor[] entries, String nodePath, PreferenceChangeListener listener) {
        PreferencesEntryTree.Node n;
        if (listener != null) {
            String path = nodePath.toLowerCase();
            Preferences uprefs = this.coreEngine.getUserPreferences();
            Preferences uNode = uprefs.node(path);
            uNode.removePreferenceChangeListener(listener);
        }
        if ((n = this.entryTree.getNode(nodePath)) != null) {
            n.removeEntries(entries);
            if (n.getEntries().length == 0 && !n.hasChildren()) {
                this.entryTree.removeNode(n);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(HOME_DIR.getKey()) && evt.getNode().isUserNode()) {
            this.setHomeDirectory(evt.getNewValue());
        } else if (evt.getKey().equals(AUTO_FILE.getKey()) && evt.getNode().isUserNode()) {
            this.setAutoActivateFile(evt.getNewValue());
        }
    }

    @Override
    public Preferences getUserPreferences() {
        return this.coreEngine.getUserPreferences();
    }

    @Override
    public PreferencesEntryTree getPreferencesEntries() {
        return this.entryTree;
    }

    @Override
    public void deactivatePlugIn(ActivePlugIn plugIn) {
        try {
            this.firePlugInClosing(plugIn);
            this.coreEngine.deactivatePlugIn(plugIn);
        }
        catch (Throwable e) {
            this.handleError(e.toString(), e);
        }
    }

    @Override
    public ActivePlugIn activatePlugIn(Class<? extends ActivePlugIn> plugInClass) {
        try {
            List<ActivePlugIn> apis = this.coreEngine.activatePlugIn(plugInClass);
            if (apis != null) {
                ActivePlugIn api2 = null;
                for (ActivePlugIn api2 : apis) {
                    api2.setup(this);
                    this.firePlugInOpened(api2);
                }
                return api2;
            }
            return null;
        }
        catch (Throwable e) {
            this.handleError(e.toString(), e);
            return null;
        }
    }

    @Override
    public Collection<? extends ActivePlugIn> getOpenActivePlugIns() {
        return this.coreEngine.getActivePlugIns();
    }

    @Override
    public PlugInManager getPlugInManager() {
        return this.coreEngine.getPlugInManager();
    }

    @Override
    public void addActivePlugInListener(ActivePlugInListener listener) {
        this.activePlugInListeners.add(listener);
    }

    @Override
    public void removeActivePlugInListener(ActivePlugInListener listener) {
        this.activePlugInListeners.remove(listener);
    }

    void firePlugInOpened(ActivePlugIn pi) {
        Iterator<ActivePlugInListener> i = this.activePlugInListeners.iterator();
        while (i.hasNext()) {
            i.next().plugInActivated(this, pi);
        }
    }

    void firePlugInClosing(ActivePlugIn pi) {
        Iterator<ActivePlugInListener> i = this.activePlugInListeners.iterator();
        while (i.hasNext()) {
            i.next().plugInDeactiviating(this, pi);
        }
    }

    @Override
    public void autoActivatePlugIns() {
        if (this.autoActivateFile != null) {
            try {
                BufferedReader r = new BufferedReader(new FileReader(this.autoActivateFile));
                String line = "";
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    try {
                        ArrayList l = new ArrayList(this.coreEngine.getPlugInManager().getPlugInList("ACTIVE_PLUGIN"));
                        boolean loaded = false;
                        for (Class c : l) {
                            if (!c.getName().equals(line)) continue;
                            this.activatePlugIn(c);
                            loaded = true;
                            break;
                        }
                        if (loaded) continue;
                        throw new PlugInException(PlatformTexts.getString("Platform.ERROR_PLUGIN_NOT_LOADED"));
                    }
                    catch (PlugInException e) {
                        String message = MessageFormat.format(PlatformTexts.getString("Platform.ERROR_PLUGIN_NOT_ACTIVATED"), line);
                        this.handleError(message, e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                String message = MessageFormat.format(PlatformTexts.getString("Platform.ERROR_PLUGIN_FILE_NOT_FOUND"), this.autoActivateFile.getAbsolutePath());
                this.handleError(message, e);
            }
            catch (IOException e) {
                String message = MessageFormat.format(PlatformTexts.getString("Platform.ERROR_PLUGIN_FILE_NOT_READ"), this.autoActivateFile.getAbsolutePath());
                this.handleError(message, e);
            }
        } else {
            log.warn((Object)"No auto-activate file set");
        }
    }

    @Override
    public ActivePlugIn getPlugInInstance(Class<? extends ActivePlugIn> plugInClass) {
        log.debug((Object)("Getting instance of " + plugInClass));
        ActivePlugIn api = this.coreEngine.getPlugInInstance(plugInClass);
        return api;
    }

    @Override
    public File getPlugInAutoLoadFile() {
        return this.coreEngine.getPlugInFile();
    }

    File getPlugInPath() {
        return this.coreEngine.getPlugInPath();
    }

    public File getAutoActivateFile() {
        return this.autoActivateFile;
    }

    @Override
    public void addQuickActionSet(ActionSet actionSet) {
        ActivePlugIn pi = actionSet.getPlugin();
        List<ActionSet> actionSets = this.quickActionSets.get(pi);
        if (actionSets == null) {
            actionSets = new ArrayList<ActionSet>();
            this.quickActionSets.put(pi, actionSets);
        }
        actionSets.add(actionSet);
    }

    @Override
    public void removeQuickActionSets(ActivePlugIn pi) {
        List<ActionSet> actionSets = this.quickActionSets.get(pi);
        if (actionSets != null) {
            actionSets.clear();
        }
        this.quickActionSets.remove(pi);
    }

    @Override
    public List<ActionSet> getQuickActionSets(ActivePlugIn pi) {
        List<ActionSet> ol = this.quickActionSets.get(pi);
        ArrayList<Object> l = ol == null ? new ArrayList() : new ArrayList<ActionSet>(ol);
        for (Map.Entry<ActionSet, ActivePlugIn> e : this.quickActionEncapsulations.entrySet()) {
            if (!e.getValue().equals(pi)) continue;
            l.add(e.getKey());
        }
        Collections.sort(l, new Comparator<ActionSet>(){

            @Override
            public int compare(ActionSet o1, ActionSet o2) {
                int fo = o1.getOrder();
                int so = o2.getOrder();
                return fo - so;
            }
        });
        return l;
    }

    protected void setHomeDirectory(String fileName) {
        this.homePath = fileName.equals("") ? null : new File(fileName);
    }

    @Override
    public File getHomeDirectory() {
        return this.homePath;
    }

    protected void setAutoActivateFile(String fileName) {
        this.autoActivateFile = fileName.equals("") ? null : new File(fileName);
    }

    public void plugInsChanged(PlugInManager pim) {
    }

    public void plugInTypesChanged(PlugInManager pim) {
        try {
            pim.loadPlugIns(this.coreEngine.getPreferredPlugInLoader(false), false);
        }
        catch (PlugInException e) {
            this.handleError(e.toString(), e);
        }
    }

    @Override
    public void close() {
        switch (this.getUI().sendMessage(PlatformTexts.getString("Platform.QUERY_EXIT_PROCEED"), PlatformTexts.getString("Platform.TITLE_EXIT_PROCEED"), (byte)1)) {
            case 1: {
                break;
            }
            case 0: {
                return;
            }
        }
        if (this.ui != null) {
            this.ui.exit();
        }
        System.exit(0);
    }

    @Override
    public void shutDown() {
        System.exit(0);
    }

    protected <T extends ActivePlugIn> void activatePlugins() {
        File f;
        ArrayList allClasses;
        Collection<? extends ActivePlugIn> open = this.getOpenActivePlugIns();
        try {
            allClasses = new ArrayList(this.getPlugInManager().getPlugInList("ACTIVE_PLUGIN"));
        }
        catch (PlugInException e1) {
            this.handleError(e1.toString(), e1);
            return;
        }
        for (ActivePlugIn activePlugIn : open) {
            allClasses.remove(activePlugIn.getClass());
        }
        PlugInClassListSelectionDescriptor plugin = new PlugInClassListSelectionDescriptor(PlatformTexts.getString("Platform.MESSAGE_SELECT_PLUGIN_ACT"), null, "PLUGIN", allClasses, true);
        BooleanDescriptor booleanDescriptor = new BooleanDescriptor(PlatformTexts.getString("Platform.MESSAGE_AUTO_ACTIVATE"), null, "AUTO");
        DefaultDataHolder dh = new DefaultDataHolder(new DataDescriptor[]{plugin, booleanDescriptor});
        boolean ok = this.getUI().inputData((DataHolder)dh, PlatformTexts.getString("Platform.TITLE_ACT_PLUGIN"));
        if (!ok) {
            return;
        }
        Class pic = (Class)dh.getData("PLUGIN");
        if (pic == null) {
            return;
        }
        boolean autoActivate = (Boolean)dh.getData("AUTO");
        this.activatePlugIn(pic);
        if (autoActivate && (f = this.getAutoActivateFile()) != null) {
            try {
                FileWriter fw = new FileWriter(f, true);
                new PrintWriter(fw).println(pic.getName());
                fw.close();
            }
            catch (IOException e) {
                this.handleError(PlatformTexts.getString("Platform.ERROR_PLUGIN_FILE_NOT_ACCESSIBLE") + e.toString(), e);
            }
        }
    }

    protected void deActivatePlugins() {
        ArrayList<? extends ActivePlugIn> open = new ArrayList<ActivePlugIn>(this.getOpenActivePlugIns());
        open.remove(this.getUI());
        PlugInListSelectionDescriptor dd = new PlugInListSelectionDescriptor(PlatformTexts.getString("Platform.MESSAGE_SELECT_PLUGIN_DEACT"), null, "PLUGIN", open, true);
        DefaultDataHolder dh = new DefaultDataHolder(new DataDescriptor[]{dd});
        boolean ok = this.getUI().inputData((DataHolder)dh, PlatformTexts.getString("Platform.TITLE_DEACT_PLUGIN"));
        if (!ok) {
            return;
        }
        ActivePlugIn ap = (ActivePlugIn)dh.getData("PLUGIN");
        if (ap != null) {
            this.deactivatePlugIn(ap);
        }
    }

    @Override
    public PlugInLoader getPreferredPlugInLoader(boolean overrideNameFile) {
        return this.coreEngine.getPreferredPlugInLoader(overrideNameFile);
    }

    @Override
    public void sendCommand(String command, PrintStream out) {
        this.parser.parseCommand(command, out == null ? System.out : out);
    }

    @Override
    public List<ActionSet> getAllActionSets() {
        return Collections.unmodifiableList(this.actionGroups);
    }

    @Override
    public void encapsulateActions(ActivePlugIn encapsulator, ActivePlugIn encapsulatee) {
        List<ActionSet> l = this.quickActionSets.get(encapsulatee);
        if (l != null) {
            for (ActionSet s : l) {
                this.quickActionEncapsulations.put(s, encapsulator);
            }
        }
        if ((l = this.getActionSets(encapsulatee)) != null) {
            for (ActionSet s : l) {
                this.actionEncapsulations.put(s, encapsulator);
            }
        }
    }

    @Override
    public void deencapsulateActions(ActivePlugIn encapsulator, ActivePlugIn encapsulatee) {
        List<ActionSet> l = this.quickActionSets.get(encapsulatee);
        if (l != null) {
            for (ActionSet s : l) {
                if (!encapsulator.equals(this.quickActionEncapsulations.get(s))) continue;
                this.quickActionEncapsulations.remove(s);
            }
        }
        if ((l = this.getActionSets(encapsulatee)) != null) {
            for (ActionSet s : l) {
                this.actionEncapsulations.remove(s);
            }
        }
    }

    @Override
    public List<ActionSet> getActionSets(ActivePlugIn api) {
        ArrayList<ActionSet> l = new ArrayList<ActionSet>();
        for (ActionSet as : this.actionGroups) {
            ActivePlugIn owner = as.getPlugin();
            ActivePlugIn encap = this.actionEncapsulations.get(as);
            if (encap != null) {
                owner = encap;
            }
            if (!api.equals(owner)) continue;
            l.add(as);
        }
        Collections.sort(l, new Comparator<ActionSet>(){

            @Override
            public int compare(ActionSet o1, ActionSet o2) {
                int fo = o1.getOrder();
                int so = o2.getOrder();
                return fo - so;
            }
        });
        return l;
    }

    protected void addCommands(String groupID, UserAction[] groupActions) {
        if (groupID == null) {
            for (int i = 0; i < groupActions.length; ++i) {
                UserAction a = groupActions[i];
                Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                DefaultCommand command = new DefaultCommand(name, desc);
                this.commands.addCommand(command);
                this.interpreter.putCommand(new ActionInterpreter.CommandKey(command, null), a);
            }
        } else if (groupID.indexOf(47) > 0) {
            Command topcommand;
            String[] ids = groupID.split("\\/");
            Command[] topcomms = CommandSet.getCommands(this.commands.getCommands(), ids[0]);
            if (topcomms.length == 0) {
                topcommand = new DefaultCommand(ids[0], ids[0] + " menu");
                this.commands.addCommand(topcommand);
            } else {
                topcommand = topcomms[0];
            }
            Command.Option subcommand = topcommand.getOption(ids[1]);
            if (subcommand == null) {
                subcommand = new DefaultCommand.Option(ids[1], ids[1] + " submenu", true);
                topcommand.addOption(subcommand);
            }
            for (int i = 0; i < groupActions.length; ++i) {
                UserAction a = groupActions[i];
                Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                DefaultCommand.Option option = new DefaultCommand.Option(name, desc, true);
                subcommand.addOption(option);
                this.interpreter.putCommand(new ActionInterpreter.CommandKey(topcommand, subcommand, option), a);
            }
        } else {
            Command command;
            Command[] comms = CommandSet.getCommands(this.commands.getCommands(), groupID);
            if (comms.length == 0) {
                command = new DefaultCommand(groupID, groupID + " menu");
                this.commands.addCommand(command);
            } else {
                command = comms[0];
            }
            for (int i = 0; i < groupActions.length; ++i) {
                UserAction a = groupActions[i];
                Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                DefaultCommand.Option option = new DefaultCommand.Option(name, desc, true);
                command.addOption(option);
                this.interpreter.putCommand(new ActionInterpreter.CommandKey(command, option), a);
            }
        }
    }

    @Override
    public void addActionSet(ActionSet actionSet) {
        this.addCommands(actionSet.getGroupID(), actionSet.getActions());
        this.actionGroups.add(actionSet);
        Iterator<ActionSetListener> i = this.actionGroupListeners.iterator();
        while (i.hasNext()) {
            i.next().actionSetAdded(actionSet);
        }
    }

    protected void removeCommands(String groupID, UserAction[] groupActions) {
        block6: {
            block7: {
                block5: {
                    if (groupID != null) break block5;
                    for (int i = 0; i < groupActions.length; ++i) {
                        UserAction a = groupActions[i];
                        Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                        Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                        String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                        String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                        DefaultCommand.Option command = new DefaultCommand.Option(name, desc, true);
                        this.commands.removeCommand(command);
                        this.interpreter.removeCommand(new ActionInterpreter.CommandKey(command, null));
                    }
                    break block6;
                }
                if (groupID.indexOf(47) <= 0) break block7;
                String[] ids = groupID.split("\\/");
                Command[] topcomms = CommandSet.getCommands(this.commands.getCommands(), ids[0]);
                if (topcomms.length <= 0) {
                    return;
                }
                Command topcommand = topcomms[0];
                Command.Option subcommand = topcommand.getOption(ids[1]);
                if (subcommand == null) {
                    subcommand = new DefaultCommand.Option(ids[1], ids[1] + " submenu", true);
                    topcommand.removeOption(subcommand);
                }
                for (int i = 0; i < groupActions.length; ++i) {
                    UserAction a = groupActions[i];
                    Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                    Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                    String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                    String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                    DefaultCommand.Option option = new DefaultCommand.Option(name, desc, true);
                    subcommand.removeOption(option);
                    this.interpreter.removeCommand(new ActionInterpreter.CommandKey(topcommand, subcommand, option));
                }
                break block6;
            }
            Command[] comms = CommandSet.getCommands(this.commands.getCommands(), groupID);
            if (comms.length != 0) break block6;
            DefaultCommand command = new DefaultCommand(groupID, groupID + " menu");
            this.commands.removeCommand(command);
            for (int i = 0; i < groupActions.length; ++i) {
                UserAction a = groupActions[i];
                Object nameO = a.getValue("net.sf.apptools.UserAction.caption");
                Object descO = a.getValue("net.sf.apptools.UserAction.tooltip");
                String name = nameO == null ? PlatformTexts.getString("Platform.ACTION_NAME_UNKNOWN") : nameO.toString();
                String desc = descO == null ? PlatformTexts.getString("Platform.ACTION_TOOLTIP_UNKNOWN") : descO.toString();
                DefaultCommand.Option option = new DefaultCommand.Option(name, desc, true);
                command.removeOption(option);
                this.interpreter.removeCommand(new ActionInterpreter.CommandKey(command, option));
            }
        }
    }

    @Override
    public void removeActionSets(ActivePlugIn api) {
        Iterator<ActionSet> ai = this.actionGroups.iterator();
        while (ai.hasNext()) {
            ActionSet as = ai.next();
            if (!api.equals(as.getPlugin())) continue;
            ai.remove();
            this.removeCommands(as.getGroupID(), as.getActions());
            Iterator<ActionSetListener> i = this.actionGroupListeners.iterator();
            while (i.hasNext()) {
                i.next().actionSetRemoved(as);
            }
        }
    }

    @Override
    public void addActionGroupListener(ActionSetListener listener) {
        this.actionGroupListeners.add(listener);
    }

    @Override
    public void removeActionGroupListener(ActionSetListener listener) {
        this.actionGroupListeners.remove(listener);
    }

    @Override
    public void runTask(Task t) {
        boolean consumed = false;
        Iterator<TaskListener> i = this.taskListeners.iterator();
        while (i.hasNext()) {
            if (consumed) continue;
            consumed = i.next().taskStarting(t);
        }
        if (!consumed) {
            t.run();
        }
        i = this.taskListeners.iterator();
        while (i.hasNext()) {
            i.next().taskEnded(t);
        }
    }

    @Override
    public void addTaskListener(TaskListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskListener(TaskListener listener) {
        this.taskListeners.remove(listener);
    }

    public void handleError(String message, Throwable t) {
        String title;
        log.error((Object)message, t);
        String string = title = t instanceof Error ? PlatformTexts.getString("Platform.TITLE_ERROR") : PlatformTexts.getString("Platform.TITLE_EXCEPTION");
        if (this.getUI() != null) {
            this.getUI().sendMessage(message, title, (byte)0);
        }
    }

    public boolean respondToError(String message, Throwable t) {
        String title;
        log.error((Object)message, t);
        String string = title = t instanceof Error ? PlatformTexts.getString("Platform.TITLE_ERROR") : PlatformTexts.getString("Platform.TITLE_EXCEPTION");
        if (this.getUI() != null) {
            byte result = this.getUI().sendMessage(message, title, (byte)1);
            return result == 1;
        }
        return true;
    }
}

