/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.apptools.CoreEngine;
import net.sf.apptools.RequirementsResolver;
import net.sf.apptools.graph.GraphUtils;
import net.sf.apptools.graph.GraphVertex;
import net.sf.apptools.graph.SimpleDirectedEdge;
import net.sf.apptools.graph.SimpleGraph;
import net.sf.apptools.graph.SimpleVertex;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequirementsResolver
implements RequirementsResolver {
    static Log logger = LogFactory.getLog(DefaultRequirementsResolver.class);

    public List<ActivePlugIn> getRequirements(ActivePlugIn ap, CoreEngine engine, ClassLoader classLoader) throws PlugInException {
        Map<String, String> requirements = ap.getPlugInRequirements();
        ArrayList<ActivePlugIn> reqList = new ArrayList<ActivePlugIn>();
        if (requirements == null) {
            reqList.add(ap);
        } else if (requirements.isEmpty()) {
            reqList.add(ap);
        } else {
            try {
                RequirementsGraph g = new RequirementsGraph();
                Map<Class<?>, ActivePlugIn> instances = g.populate(ap, engine, classLoader);
                List<Requirement> sortedRequirements = g.sortRequirements();
                if (sortedRequirements == null) {
                    logger.error((Object)"Cyclic Plug-in dependencies");
                    throw new PlugInException("Cyclic plug-in requirements are not allowed.");
                }
                for (Requirement r : sortedRequirements) {
                    Class<?> pic = r.getPlugInClass();
                    String version = r.getVersion();
                    logger.debug((Object)("Required " + pic));
                    if (pic != ap.getClass()) {
                        String pv;
                        ActivePlugIn pi = engine.getPlugInInstance(pic);
                        if (pi == null) {
                            logger.info((Object)("No active instance found for " + pic));
                            pi = instances.get(pic);
                            if (pi == null) {
                                throw new PlugInException("No instance found for " + pic);
                            }
                            engine.addActivePlugIn(pi);
                            reqList.add(pi);
                        }
                        if (Requirement.sufficientVersion(pv = pi.getVersion(), version)) continue;
                        throw new PlugInException(MessageFormat.format("Version {0} of the PlugIn {1} required, but version {2} found.", version, pic.getName(), pv));
                    }
                    reqList.add(ap);
                }
                g = null;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"Could not load a required PlugIn class", (Throwable)e);
                throw new PlugInException("A required PlugIn could not be found.", (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)"Could not instantiate a required PlugIn class", (Throwable)e);
                throw new PlugInException("A required PlugIn could not be instantiated.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"Could not access a required PlugIn class", (Throwable)e);
                throw new PlugInException("A required PlugIn could not be accessed.", (Throwable)e);
            }
        }
        return reqList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequirementsGraph
    extends SimpleGraph {
        private static final String KEY_REQUIREMENT = "REQUIREMENT";

        RequirementsGraph() {
        }

        public Requirement getRequirement(GraphVertex v) {
            return (Requirement)v.getData(KEY_REQUIREMENT);
        }

        public Class<?> getPlugInClass(GraphVertex v) {
            return this.getRequirement(v).getPlugInClass();
        }

        public String getVersion(GraphVertex v) {
            return this.getRequirement(v).getVersion();
        }

        public GraphVertex getVertex(Class<?> plugInClass) {
            for (GraphVertex v : this.getVertices()) {
                if (!this.getPlugInClass(v).equals(plugInClass)) continue;
                return v;
            }
            return null;
        }

        public GraphVertex createAndAddVertex(Class<?> plugInClass, String version) {
            SimpleVertex v = new SimpleVertex();
            Requirement r = new Requirement(plugInClass, version);
            v.putData(KEY_REQUIREMENT, r);
            this.addVertex(v);
            return v;
        }

        public Map<Class<?>, ActivePlugIn> populate(ActivePlugIn plugIn, CoreEngine engine, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            GraphVertex root = this.createAndAddVertex(plugIn.getClass(), plugIn.getVersion());
            HashMap newInstances = new HashMap();
            this.populateGraph(plugIn, root, engine, loader, newInstances);
            return newInstances;
        }

        public List<Requirement> sortRequirements() {
            Map<Integer, GraphVertex> sorted = GraphUtils.DFSTopoSort(this);
            if (sorted == null) {
                return null;
            }
            return GraphUtils.getSortedContents(sorted, KEY_REQUIREMENT);
        }

        private void populateGraph(ActivePlugIn plugin, GraphVertex root, CoreEngine engine, ClassLoader loader, Map<Class<?>, ActivePlugIn> newInstances) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            Map<String, String> req = plugin.getPlugInRequirements();
            if (req != null) {
                Set<String> keys = req.keySet();
                for (String key : keys) {
                    String className = key.toString();
                    String version = req.get(key).toString();
                    Class<?> pic = null;
                    pic = Class.forName(className, true, loader);
                    GraphVertex v = this.getVertex(pic);
                    if (v == null) {
                        v = this.createAndAddVertex(pic, version);
                    } else {
                        Requirement r = this.getRequirement(v);
                        String otherVersion = r.getVersion();
                        String newVersion = Requirement.getHighestVersion(version, otherVersion);
                        r.setVersion(newVersion);
                    }
                    this.addEdge(new SimpleDirectedEdge(root, v));
                    ActivePlugIn ap = engine.getPlugInInstance(pic);
                    if (ap == null) {
                        ap = (ActivePlugIn)pic.newInstance();
                        newInstances.put(pic, ap);
                    }
                    this.populateGraph(ap, v, engine, loader, newInstances);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Requirement {
        protected Class<?> plugInClass;
        protected String version;

        public static String getHighestVersion(String v1, String v2) {
            if (v2 == null) {
                return v1;
            }
            if (v1 == null) {
                return v2;
            }
            String[] sv1 = v1.split("\\.");
            String[] sv2 = v2.split("\\.");
            int length = Math.min(sv1.length, sv2.length);
            for (int i = 0; i < length; ++i) {
                int iv2;
                int iv1 = Integer.parseInt(sv1[i]);
                if (iv1 > (iv2 = Integer.parseInt(sv2[i]))) {
                    return v1;
                }
                if (iv2 <= iv1) continue;
                return v2;
            }
            if (sv2.length > sv1.length) {
                return v2;
            }
            return v1;
        }

        public static boolean sufficientVersion(String current, String required) {
            return Requirement.getHighestVersion(current, required).equals(current);
        }

        public Requirement(Class<?> plugInClass, String version) {
            this.plugInClass = plugInClass;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Class<?> getPlugInClass() {
            return this.plugInClass;
        }
    }
}

