/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import java.text.DateFormat;
import java.util.Date;
import net.sf.apptools.data.AbstractDataDescriptor;
import net.sf.apptools.data.ConvertibleDataDescriptor;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDescriptor
extends AbstractDataDescriptor
implements ConvertibleDataDescriptor {
    DateFormat df = DateFormat.getDateInstance(3);

    public DateDescriptor(String name, String description, String propertyName, boolean required) {
        super(name, description, propertyName, required);
    }

    @Override
    public Class<?> getDataType() {
        return Date.class;
    }

    @Override
    public Converter getToStringConverter() {
        return new DateToStringConverter();
    }

    @Override
    public Converter getToValueConverter() {
        return new DateConverter();
    }

    public class DateToStringConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return value;
            }
            if (value instanceof Date) {
                return DateDescriptor.this.df.format((Date)value);
            }
            return null;
        }
    }

    public class DateConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value instanceof String) {
                try {
                    Date date = DateDescriptor.this.df.parse((String)value);
                    return date;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return value;
        }
    }
}

