/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.apptools.plugin.PlugInLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlugInLoader
implements PlugInLoader {
    protected ClassLoader classLoader;
    protected Log log = LogFactory.getLog(AbstractPlugInLoader.class);

    public AbstractPlugInLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
    }

    protected List<String> selectPlugIns(Collection<String> classNames, Class<?>[] pluginClasses, Collection<Class<?>>[] sets) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String name : classNames) {
            Class<?> c = null;
            try {
                this.log.debug((Object)("Checking for plug-in: " + name));
                c = Class.forName(name, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                messages.add("PlugIn or required class not found: " + e.toString());
            }
            catch (Throwable t) {
                messages.add("Error discovering plugins: " + t.toString());
                this.log.debug((Object)("Error discovering plugins: " + t.getMessage()), t);
            }
            if (c == null) continue;
            for (int s = 0; s < sets.length; ++s) {
                if (pluginClasses[s] == null || !pluginClasses[s].isAssignableFrom(c) || c.isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
                try {
                    c.getConstructor(new Class[0]);
                    sets[s].add(c);
                    continue;
                }
                catch (SecurityException e1) {
                    messages.add("Security exception: " + e1.getMessage());
                    continue;
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
            }
        }
        return messages;
    }

    protected Set<String> getClassesInPath(String root, String path) {
        HashSet<String> set;
        block4: {
            File file;
            block6: {
                block5: {
                    block3: {
                        set = new HashSet<String>();
                        file = new File(root, path);
                        if (!this.isZipFile(root)) break block3;
                        String[] files = this.readZipFile(file);
                        for (int i = 0; i < files.length; ++i) {
                            if (!this.isClassFile(files[i])) continue;
                            set.add(this.getClassName(files[i]));
                        }
                        break block4;
                    }
                    if (!file.isDirectory()) break block5;
                    String[] files = file.list();
                    for (int i = 0; i < files.length; ++i) {
                        set.addAll(this.getClassesInPath(root, path + File.separatorChar + files[i]));
                    }
                    break block4;
                }
                if (!this.isClassFile(path)) break block6;
                set.add(this.getClassName(path));
                break block4;
            }
            if (!this.isZipFile(path)) break block4;
            String[] files = this.readZipFile(file);
            for (int i = 0; i < files.length; ++i) {
                if (!this.isClassFile(files[i])) continue;
                set.add(this.getClassName(files[i]));
            }
        }
        return set;
    }

    protected boolean isClassFile(String file) {
        return file.endsWith(".class");
    }

    protected boolean isZipFile(String file) {
        return file.toLowerCase().endsWith(".zip") || file.toLowerCase().endsWith(".jar");
    }

    protected String[] readZipFile(File file) {
        ArrayList<String> l = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                l.add(zipEntry.getName());
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return l.toArray(new String[l.size()]);
    }

    protected String getClassName(String classFileName) {
        String prefix = classFileName.substring(0, classFileName.length() - ".class".length());
        String periodName = prefix.replace(File.separatorChar, '.');
        String periodName2 = periodName.replace('/', '.');
        if (periodName2.startsWith(".")) {
            return periodName2.substring(1);
        }
        return periodName2;
    }
}

