/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInFileWriter;
import net.sf.apptools.plugin.PlugInLoader;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.plugin.PlugInManagerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlugInManager
implements PlugInManager {
    List<PlugInManagerListener> listeners;
    private Map<String, String> descriptionMap = new HashMap<String, String>();
    private Map<String, Collection<Class<?>>> classListMap = new HashMap();
    private Map<String, Class<?>> classMap = new HashMap();

    public DefaultPlugInManager() {
        this.listeners = new ArrayList<PlugInManagerListener>();
    }

    public void registerPlugInType(String identifier, Class<?> plugInClass, String description) {
        this.registerPlugInTypes(new String[]{identifier}, new Class[]{plugInClass}, new String[]{description});
    }

    @Override
    public void registerPlugInTypes(String[] identifiers, Class<?>[] plugInClasses, String[] descriptions) {
        for (int i = 0; i < identifiers.length; ++i) {
            if (this.descriptionMap.containsKey(identifiers[i])) continue;
            this.descriptionMap.put(identifiers[i], descriptions[i]);
            this.classMap.put(identifiers[i], plugInClasses[i]);
            this.classListMap.put(identifiers[i], new TreeSet(new ClassComparator()));
        }
        this.firePlugInTypesChanged();
    }

    @Override
    public void unRegisterPlugInType(String identifier) {
        this.unRegisterPlugInTypes(new String[]{identifier});
    }

    @Override
    public void unRegisterPlugInTypes(String[] identifiers) {
        for (int i = 0; i < identifiers.length; ++i) {
            this.descriptionMap.remove(identifiers[i]);
            this.classMap.remove(identifiers[i]);
            this.classListMap.remove(identifiers[i]);
        }
        this.firePlugInTypesChanged();
    }

    @Override
    public String[] getIdentifiers() {
        Set<String> ids = this.classMap.keySet();
        return ids.toArray(new String[ids.size()]);
    }

    private String[] getDescriptions(String[] identifiers) {
        String[] descs = new String[identifiers.length];
        for (int i = 0; i < descs.length; ++i) {
            try {
                descs[i] = this.getPlugInDescription(identifiers[i]);
                continue;
            }
            catch (PlugInException e) {
                descs[i] = "No description";
            }
        }
        return descs;
    }

    private Collection<Class<?>>[] getClassLists(String[] identifiers) {
        Collection[] lists = new Collection[identifiers.length];
        for (int i = 0; i < lists.length; ++i) {
            try {
                lists[i] = this.getPlugInList(identifiers[i]);
                continue;
            }
            catch (PlugInException e) {
                lists[i] = new HashSet();
            }
        }
        return lists;
    }

    @Override
    public String getPlugInDescription(String identifier) throws PlugInException {
        String o = this.descriptionMap.get(identifier);
        if (o == null) {
            throw new PlugInException("Plug-in type not registered with manager: " + identifier);
        }
        return o.toString();
    }

    @Override
    public Collection<Class<?>> getPlugInList(String identifier) throws PlugInException {
        Collection<Class<?>> list = this.classListMap.get(identifier);
        if (list == null) {
            throw new PlugInException("Plug-in type not registered with manager: " + identifier);
        }
        return list;
    }

    @Override
    public List<String> loadPlugIns(PlugInLoader loader, boolean append) {
        int i;
        ArrayList<String> messages = new ArrayList<String>();
        String[] identifiers = this.getIdentifiers();
        Class[] classes = new Class[identifiers.length];
        Collection[] old = new Collection[identifiers.length];
        Collection[] classLists = new Collection[identifiers.length];
        for (i = 0; i < identifiers.length; ++i) {
            classLists[i] = this.classListMap.get(identifiers[i]);
            old[i] = new HashSet();
            if (append) {
                old[i].addAll(classLists[i]);
            }
            classLists[i].clear();
            classes[i] = this.classMap.get(identifiers[i]);
        }
        messages.addAll(loader.getAvailablePlugIns(classes, classLists));
        if (append) {
            for (i = 0; i < classLists.length; ++i) {
                for (Class c : old[i]) {
                    if (classLists[i].contains(c)) continue;
                    classLists[i].add(c);
                }
            }
        }
        this.firePlugInsChanged();
        return messages;
    }

    @Override
    public void storePlugIns(PlugInFileWriter writer, OutputStream out) {
        String[] ids = this.getIdentifiers();
        writer.storePlugInLists(this.getClassLists(ids), this.getDescriptions(ids), out);
    }

    void firePlugInsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).plugInsChanged(this);
        }
    }

    void firePlugInTypesChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).plugInTypesChanged(this);
        }
    }

    @Override
    public void addListener(PlugInManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(PlugInManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void addPlugIn(String typeIdentifier, Class<?> plugInClass) throws PlugInException {
        Collection<Class<?>> classList = this.classListMap.get(typeIdentifier);
        if (classList == null) {
            throw new PlugInException("Plug-in type not registered with manager: " + typeIdentifier);
        }
        classList.add(plugInClass);
        this.firePlugInsChanged();
    }

    public void removePlugIn(String typeIdentifier, Class<?> plugInClass) throws PlugInException {
        Collection<Class<?>> classList = this.classListMap.get(typeIdentifier);
        if (classList == null) {
            throw new PlugInException("Plug-in type not registered with manager: " + typeIdentifier);
        }
        classList.remove(plugInClass);
        this.firePlugInsChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassComparator
    implements Comparator<Class<?>> {
        ClassComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            String cn1 = o1.getName();
            String cn2 = o2.getName();
            return cn1.compareTo(cn2);
        }
    }
}

