/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.Task;

public abstract class AbstractTask
implements Task {
    protected ErrorHandler handler;
    boolean aborted = false;
    boolean completed = false;
    AtomicInteger progress;
    protected int maxProgress;
    protected int minProgress;
    String[] status;
    String title;
    int statusLevels;
    protected List<ProgressListener> listeners = new ArrayList<ProgressListener>();

    public AbstractTask(String title, int minProgress, int maxProgress, int statusLevels, ErrorHandler handler) {
        this.minProgress = minProgress;
        this.progress = new AtomicInteger(minProgress);
        this.maxProgress = maxProgress;
        this.title = title;
        this.statusLevels = statusLevels;
        this.handler = handler;
        this.status = new String[statusLevels];
    }

    public void abort() {
        this.aborted = true;
        this.fireAborted();
    }

    public boolean completed() {
        return this.completed;
    }

    public String getStatus(int level) {
        return this.status[level];
    }

    public int getStatusLevels() {
        return this.statusLevels;
    }

    public int getProgress() {
        return this.progress.get();
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getMinProgress() {
        return this.minProgress;
    }

    public String getTitle() {
        return this.title;
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    protected void setCompleted() {
        this.completed = true;
        this.fireCompleted();
    }

    protected void increaseProgress() {
        this.fireProgressChange(this.progress.incrementAndGet());
    }

    protected void setStatus(String status, int level) {
        try {
            this.status[level] = status;
            this.fireStatusChange(level, status);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void handleError(Throwable ex) {
        if (this.handler == null) {
            throw new RuntimeException("Cannot handle error: no error handler set", ex);
        }
        if (this.handler.respondToError(ex.toString(), ex)) {
            this.abort();
        }
    }

    protected void fireProgressChange(int newProgress) {
        Iterator<ProgressListener> i = new ArrayList<ProgressListener>(this.listeners).iterator();
        while (i.hasNext()) {
            i.next().progressChanged(this, newProgress);
        }
    }

    protected void fireStatusChange(int level, String newStatus) {
        Iterator<ProgressListener> i = new ArrayList<ProgressListener>(this.listeners).iterator();
        while (i.hasNext()) {
            i.next().statusChanged(this, level, newStatus);
        }
    }

    protected void fireAborted() {
        for (ProgressListener listener : new ArrayList<ProgressListener>(this.listeners)) {
            listener.taskAborted(this);
        }
    }

    protected void fireCompleted() {
        for (ProgressListener listener : new ArrayList<ProgressListener>(this.listeners)) {
            listener.taskCompleted(this);
        }
    }

    public void addListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }
}

