/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.apptools.prefs.EntryDescriptor;
import net.sf.apptools.prefs.FileEntryDescriptor;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.prefs.PreferencesEditor;

public class DefaultPreferencesEditor
implements PreferencesEditor {
    JLabel[] labels;
    JTextField[] fields;
    JButton[] buttons;
    JFileChooser fc;
    Preferences userPrefs;
    EntryDescriptor[] entries;
    String title;

    public DefaultPreferencesEditor(Preferences userprefs, EntryDescriptor[] entries, String title, File cwd) {
        this.fc = new JFileChooser(cwd);
        this.userPrefs = userprefs;
        this.entries = entries;
        this.title = title;
    }

    public JComponent getEditorComponent() {
        final JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Object src = e.getSource();
                    for (int i = 0; i < DefaultPreferencesEditor.this.buttons.length; ++i) {
                        if (src != DefaultPreferencesEditor.this.buttons[i] || !(DefaultPreferencesEditor.this.entries[i] instanceof FileEntryDescriptor)) continue;
                        if (((FileEntryDescriptor)DefaultPreferencesEditor.this.entries[i]).getDirectoriesOnly()) {
                            DefaultPreferencesEditor.this.fc.setFileSelectionMode(1);
                        } else {
                            DefaultPreferencesEditor.this.fc.setFileSelectionMode(0);
                        }
                        String caption = MessageFormat.format(SwingUITexts.getString("DefaultPreferencesEditor.MESSAGE_SELECT"), DefaultPreferencesEditor.this.entries[i].getDescription());
                        if (DefaultPreferencesEditor.this.fc.showDialog(panel, caption) != 0) continue;
                        DefaultPreferencesEditor.this.fields[i].setText(DefaultPreferencesEditor.this.fc.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(panel, ex.getMessage());
                }
            }
        };
        this.labels = new JLabel[this.entries.length];
        this.fields = new JTextField[this.entries.length];
        this.buttons = new JButton[this.entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            EntryDescriptor ed = this.entries[i];
            String key = ed.getKey();
            String name = ed.getDescription();
            String def = ed.getDefault();
            String brief = ed.getBrief();
            this.labels[i] = new JLabel(name + ":");
            this.labels[i].setToolTipText(brief);
            String value = this.userPrefs.get(key, def);
            this.fields[i] = new JTextField(value, 30);
            this.buttons[i] = new JButton("...");
            this.buttons[i].addActionListener(al);
        }
        GridBagConstraints gbcon = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 10, 2);
        for (int i = 0; i < this.entries.length; ++i) {
            gbcon.gridx = 0;
            panel.add((Component)this.labels[i], gbcon);
            ++gbcon.gridx;
            panel.add((Component)this.fields[i], gbcon);
            ++gbcon.gridx;
            panel.add((Component)this.buttons[i], gbcon);
            ++gbcon.gridy;
        }
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    public void savePreferences() throws BackingStoreException {
        for (int i = 0; i < this.entries.length; ++i) {
            EntryDescriptor ed = this.entries[i];
            String key = ed.getKey();
            String value = this.fields[i].getText();
            byte type = ed.getType();
            if (type != 1) continue;
            this.userPrefs.put(key, value);
        }
        this.userPrefs.flush();
    }

    public String getTitle() {
        return this.title;
    }
}

