/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.apptools.ui.swing.SwingUITexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIUtils {
    static final char suffixSeparator = '.';

    public static ImageIcon getIcon(Class<?> loader, String path, String desc) {
        URL iconURL = loader.getResource(path);
        if (iconURL != null) {
            return new ImageIcon(iconURL, desc);
        }
        iconURL = GUIUtils.class.getResource(path);
        if (iconURL != null) {
            return new ImageIcon(iconURL, desc);
        }
        return null;
    }

    public static Image getImage(Class<?> loader, String path) {
        URL url = loader.getResource(path);
        if (url != null) {
            try {
                return ImageIO.read(url);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static Frame getParentFrame(Component c) {
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return GUIUtils.getParentFrame(parent);
    }

    public static Point suggestLocation(Window w, Frame parent) {
        if (parent != null) {
            Dimension parentSize = parent.getSize();
            Dimension size = w.getSize();
            Point location = new Point((parentSize.width - size.width) / 2, (parentSize.height - size.height) / 2);
            if (location.x < 0 || location.y < 0) {
                location = new Point(0, 0);
            }
            return location;
        }
        return new Point(0, 0);
    }

    public static void checkSize(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setSize(frameSize);
    }

    public static void checkSize(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        dialog.setSize(frameSize);
    }

    public static File selectDir(Component comp, JFileChooser fileChooser, File defaultDir, String caption) {
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(defaultDir == null ? new File("").getParentFile() : defaultDir);
        File targetFile = null;
        if (fileChooser.showDialog(comp, caption == null ? SwingUITexts.getString("CAPTION_OPEN_FILE") : caption) == 0) {
            targetFile = fileChooser.getSelectedFile();
        }
        fileChooser.setFileSelectionMode(2);
        return targetFile;
    }

    public static File selectFile(Component comp, JFileChooser fileChooser, FileFilter filter, File defaultFile, String caption) {
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (filter != null) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(defaultFile == null ? new File("") : defaultFile);
        File targetFile = null;
        if (fileChooser.showDialog(comp, caption == null ? SwingUITexts.getString("CAPTION_OPEN_FILE") : caption) == 0) {
            targetFile = fileChooser.getSelectedFile();
        }
        if (filter != null) {
            fileChooser.removeChoosableFileFilter(filter);
        }
        return targetFile;
    }

    public static File[] selectFiles(Component comp, JFileChooser fileChooser, FileFilter filter, String caption) {
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (filter != null) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setMultiSelectionEnabled(true);
        File[] targetFiles = null;
        if (fileChooser.showDialog(comp, caption == null ? SwingUITexts.getString("CAPTION_OPEN_FILES") : caption) == 0) {
            targetFiles = fileChooser.getSelectedFiles();
        }
        if (filter != null) {
            fileChooser.removeChoosableFileFilter(filter);
        }
        return targetFiles;
    }

    public static File selectSaveFile(Component comp, JFileChooser fileChooser, FileFilter filter, File defaultFile, String caption, String autoSuffix) {
        String theCaption;
        File file = defaultFile;
        boolean gotFile = false;
        String string = theCaption = caption == null ? SwingUITexts.getString("CAPTION_SAVE_FILE") : caption;
        while (!gotFile) {
            if ((file = GUIUtils.selectFile(comp, fileChooser, filter, file, theCaption)) == null) {
                return null;
            }
            if (autoSuffix != null && !file.getName().endsWith('.' + autoSuffix)) {
                file = new File(file.getAbsolutePath() + '.' + autoSuffix);
            }
            if (file.exists()) {
                int result = JOptionPane.showConfirmDialog(comp, MessageFormat.format("", file.getName()), theCaption, 0);
                if (result != 0) continue;
                gotFile = true;
                continue;
            }
            gotFile = true;
        }
        return file;
    }
}

