# Copyright (c) 2006-2008 Stanford University
# This file is part of Disperse.
#
# Disperse is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Disperse is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Disperse; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
package Bio::Disperse::FastaCmd;

use strict;

sub new {
	my ($package, $fastacmd_bin, $fastacmd_blastdb) = @_;
	my $this = {};
	$this->{'blastdb'} = $fastacmd_blastdb;
	$this->{'fastacmd'} = $fastacmd_bin;	
	
	bless $this, $package;
}

sub get_fasta
{
	my ($this, $id, $start_1based, $end_1based, $polarity) = @_;
	# change polarity to 1 & 2
	if ($polarity == -1) { $polarity = 2; }
	my $cmd = "\"$this->{'fastacmd'}\" -d \"$this->{'blastdb'}\" -s $id -L $start_1based,$end_1based -S $polarity";
	return `$cmd`;
}
1;