/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.calculators;

import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.Aligner;
import org.moltools.design.calc.SecStructCalculator;
import org.moltools.design.calc.SmithWatermanCalculator;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.design.utils.ParameterHolder;
import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.struct.DefaultNAHybridStructure;
import org.moltools.lib.struct.DefaultNASecStructure;
import org.moltools.lib.struct.NAHybridStructure;
import org.moltools.lib.struct.NASecStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWStructureCalculator
extends AbstractParameterHolder
implements SecStructCalculator {
    protected transient Aligner lac;
    protected transient int minLoopLength;
    protected static final int[] MIN_LOOP_LENGTHS = new int[]{2, 1};

    public Map<String, String> getDefaultParameters() {
        return new HashMap<String, String>();
    }

    public SWStructureCalculator() {
        this.parameters = this.getDefaultParameters();
        this.lac = new SmithWatermanCalculator();
    }

    public NASecStructure calculateStructure(NucleotideSequence seq, boolean doTemp) {
        Alignment la = this.doStrongestIntramolecularLocalAlignment(seq.seqString(), seq.getType());
        if (la == null) {
            return null;
        }
        DefaultNASecStructure s = new DefaultNASecStructure(la, seq.length());
        return s;
    }

    public NAHybridStructure calculateStructure(String seq1, String seq2, byte type1, byte type2) {
        this.lac.doAlignment(seq1, SequenceHandler.getRev((String)seq2));
        Alignment la = this.lac.getNextAlignment();
        if (la == null) {
            return null;
        }
        DefaultNAHybridStructure s = new DefaultNAHybridStructure(la, seq2.length());
        return s;
    }

    public NAHybridStructure calculateStructure(NucleotideSequence seq1, NucleotideSequence seq2) {
        return this.calculateStructure(seq1.seqString(), seq2.seqString(), seq1.getType(), seq2.getType());
    }

    protected String reverse(String str) {
        String ret = "";
        for (int i = str.length() - 1; i >= 0; --i) {
            ret = ret + str.charAt(i);
        }
        return ret;
    }

    protected boolean isOverlap(Alignment la, int length) {
        int looplength = length - la.getSecondEnd() - la.getFirstEnd();
        return looplength < this.minLoopLength;
    }

    protected Alignment doStrongestIntramolecularLocalAlignment(String seq, byte type) {
        this.minLoopLength = MIN_LOOP_LENGTHS[type];
        this.lac.doAlignment(seq, this.reverse(seq));
        Alignment la = this.lac.getNextAlignment();
        int length = seq.length();
        if (la == null) {
            return null;
        }
        if (la.getFirstStart() > la.getSecondStart()) {
            la = new SimpleAlignment(la.getSecondStart(), la.getSecondEnd(), la.getSecondString(), la.getFirstStart(), la.getFirstEnd(), la.getFirstString());
        }
        boolean overlap = this.isOverlap(la, seq.length());
        while (overlap) {
            la = this.getNextIntramolecularAlignment(length);
            if (la == null) {
                return null;
            }
            overlap = this.isOverlap(la, seq.length());
        }
        return la;
    }

    protected Alignment getNextIntramolecularAlignment(int length) {
        Alignment la = null;
        boolean overlap = true;
        while (overlap) {
            la = this.lac.getNextAlignment();
            if (la == null) {
                return null;
            }
            if (la.getFirstStart() > la.getSecondStart()) {
                la = new SimpleAlignment(la.getSecondStart(), la.getSecondEnd(), la.getSecondString(), la.getFirstStart(), la.getFirstEnd(), la.getFirstString());
            }
            overlap = this.isOverlap(la, length);
        }
        return la;
    }

    public void setLAC(Aligner l) {
        this.lac = l;
    }

    public void addParameters(Map<String, String> p) {
        this.parameters.putAll(p);
        if (this.lac instanceof ParameterHolder) {
            ((ParameterHolder)this.lac).addParameters(p);
        }
    }

    public void setParameters(Map<String, String> p) {
        this.parameters.clear();
        this.parameters.putAll(this.getDefaultParameters());
        this.parameters.putAll(p);
        if (this.lac instanceof ParameterHolder) {
            ((ParameterHolder)this.lac).setParameters(p);
        }
    }
}

