/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.acc;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.plugin.AbstractParameterPlugIn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;

public class LengthBinAcceptor
extends AbstractParameterPlugIn
implements ProbeAcceptor {
    protected static Log log = LogFactory.getLog(LengthBinAcceptor.class);
    static final String KEY_MIN_SIZE = "MIN_SIZE";
    static final String KEY_MAX_SIZE = "MAX_SIZE";
    static final String KEY_MIN_DISTANCE = "MIN_DISTANCE";
    public static DataDescriptor minSizeDesc = new IntegerDescriptor("Min. size", "Minimum fragment length", "MIN_SIZE", 1, Integer.MAX_VALUE);
    public static DataDescriptor maxSizeDesc = new IntegerDescriptor("Max. size", "Maximum fragment length", "MAX_SIZE", 1, Integer.MAX_VALUE);
    public static DataDescriptor minDistanceDesc = new IntegerDescriptor("Min. distance", "Minimum separation of lengths of selected fragments", "MIN_DISTANCE", 1, Integer.MAX_VALUE);
    int minSize;
    int maxSize;
    int minDistance;
    SortedSet<Bin> bins;

    public static String getBriefDescription() {
        return "Target length bin acceptor";
    }

    public static String getLongDescription() {
        return "Accepts a single probe per target group, requiring unique target lengths for each probe.";
    }

    protected boolean allSet() {
        if (this.getData(KEY_MIN_SIZE) == null) {
            return false;
        }
        if (this.getData(KEY_MAX_SIZE) == null) {
            return false;
        }
        return this.getData(KEY_MIN_DISTANCE) != null;
    }

    public void setData(String propName, Object newValue) {
        super.setData(propName, newValue);
        if (this.allSet()) {
            this.reset();
        }
    }

    protected void reset() {
        this.minSize = (Integer)this.getData(KEY_MIN_SIZE);
        this.maxSize = (Integer)this.getData(KEY_MAX_SIZE);
        this.minDistance = (Integer)this.getData(KEY_MIN_DISTANCE);
        this.bins = new TreeSet<Bin>();
        this.bins.add(new Bin(this.minSize, this.maxSize));
        if (log.isDebugEnabled()) {
            Iterator i = this.bins.iterator();
            while (i.hasNext()) {
                log.info(i.next());
            }
        }
    }

    public LengthBinAcceptor() {
        super(new DataDescriptor[]{minSizeDesc, maxSizeDesc, minDistanceDesc});
    }

    public boolean overridesTSSDecision() {
        return true;
    }

    public boolean overridesCandidateDecision() {
        return false;
    }

    public byte acceptArms(Probe p) {
        return 2;
    }

    public byte acceptPrimary(Probe p) {
        return 2;
    }

    public byte accept(Candidate c) {
        Probe p = (Probe)c;
        ProbeGroup group = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)c, (String)"probeGroup");
        Collection probes = group.getMembers();
        for (Probe pr : probes) {
            if (!pr.tagsAllocated() || ProbeMakerPropertyUtils.getRank((PropertyHolder)p) != 3) continue;
            return 0;
        }
        int len = ((ProbeMakerTarget)p.getTarget()).length();
        for (Bin b : this.bins) {
            Bin n;
            if (b.min > len || len > b.max) continue;
            if (b.isFull()) break;
            b.fill();
            log.debug((Object)("Added fragment of length " + len));
            b.min = len - this.minDistance;
            b.max = len + this.minDistance;
            if (b == this.bins.first() && b.min > this.minSize) {
                Bin f = new Bin(this.minSize, b.min - 1);
                this.bins.add(f);
            }
            if (b == this.bins.last() && b.max < this.maxSize) {
                Bin l = new Bin(b.max + 1, this.maxSize);
                this.bins.add(l);
            }
            if (b != this.bins.first()) {
                Bin prev = this.bins.headSet(b).last();
                log.debug((Object)("Adjusting " + prev));
                if (prev.isFull()) {
                    if (prev.max < b.min - 1) {
                        n = new Bin(prev.max - 1, b.min - 1);
                        this.bins.add(n);
                    }
                } else {
                    prev.max = b.min - 1;
                }
            }
            if (b != this.bins.last()) {
                Bin next = this.bins.tailSet(new Bin(b.min + 1, b.max)).first();
                log.debug((Object)("Adjusting " + next));
                if (next.isFull()) {
                    if (next.min > b.max + 1) {
                        n = new Bin(b.max + 1, next.min - 1);
                        this.bins.add(n);
                    }
                } else {
                    next.min = b.max + 1;
                }
            }
            if (log.isDebugEnabled()) {
                log.info((Object)"LengthBinAcceptor bins: ");
                Iterator bi = this.bins.iterator();
                while (bi.hasNext()) {
                    log.info(bi.next());
                }
            }
            return 2;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Bin
    implements Comparable<Bin> {
        int min;
        int max;
        boolean full;

        Bin(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getSize() {
            return this.max - this.min + 1;
        }

        boolean isFull() {
            return this.full;
        }

        void fill() {
            this.full = true;
        }

        @Override
        public int compareTo(Bin b) {
            if (this == b) {
                return 0;
            }
            if (this.min < b.min) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "[" + this.min + ", " + this.max + "] " + (this.full ? "Full" : "Empty");
        }
    }
}

