/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DoubleDescriptor;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DINAMeltSecStructModule
extends AbstractProbeModule {
    static final MessageType DG_SEC_STRUCT = new MessageType("DG_SEC_STRUCT", "Secondary structure dG");
    static String url = "http://www.bioinfo.rpi.edu";
    static String serverPath = "/applications/hybrid/cgi-bin/zipfold.cgi";
    public static Log log = LogFactory.getLog(DINAMeltSecStructModule.class);
    public static final String KEY_DG_LIMIT = "DG_LIMIT";
    public static final String KEY_DG_SPAN = "DG_SPAN";
    public static final String KEY_FOLD_TEMP = "FOLD_TEMP";
    public static final String KEY_NA_CONC = "NA_CONC";
    public static final String KEY_MG_CONC = "MG_CONC";
    protected transient double dGLimit;
    protected transient double dGSpan;
    protected transient double temp;
    protected transient double sodiumConc;
    protected transient double magnesiumConc;
    protected transient HttpClient client = null;

    public static String getBriefDescription() {
        return "DINAMelt secondary structure module";
    }

    public static String getLongDescription() {
        return "<html>Sends a web query to the DINAMelt web server to predict dG of secondary structure, and require it to be within certain limits.<br><b>Markham, N. R. & Zuker, M.</b> (2005) DINAMelt web server for nucleic acid melting prediction.<br><i>Nucleic Acids Res.</i>, <b>33</b>, W577-W581.</html>";
    }

    public DINAMeltSecStructModule() {
        super(new TestDescriptor[]{new TestDescriptor("Secondary structure")}, new DataDescriptor[]{new DoubleDescriptor("dG limit", "Maximum dG allowed for highest quality (usually a negative number)", KEY_DG_LIMIT, -100.0, 100.0), new DoubleDescriptor("dG span", "Maximum dG above limit allowed for intermediate quality", KEY_DG_SPAN, 0.0, 100.0), new DoubleDescriptor("Folding temperature (\ufffdC)", "The temperature in degrees celsius to use for the folding calculations", KEY_FOLD_TEMP, 0.0, 100.0), new DoubleDescriptor("Na+ conc. (M)", "The sodium ion concentration (molar) to use for the folding calculations", KEY_NA_CONC, 0.01, 1.0), new DoubleDescriptor("Mg2+ conc. (M)", "The magnesium ion concentration (molar) to use for the folding calculations", KEY_MG_CONC, 0.0, 1.0)});
        this.setData(KEY_DG_LIMIT, new Double(-5.0));
        this.setData(KEY_DG_SPAN, new Double(2.0));
        this.setData(KEY_FOLD_TEMP, new Double(37.0));
        this.setData(KEY_NA_CONC, new Double(1.0));
        this.setData(KEY_MG_CONC, new Double(0.0));
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        this.client.getHttpConnectionManager().getParams().setSoTimeout(2000);
        PostMethod method = new PostMethod(url);
        method.getParams().setCookiePolicy("ignoreCookies");
        method.setPath(serverPath);
        method.addParameter("name", "seq");
        method.addParameter("seq", p.seqString());
        method.addParameter("NA", "DNA");
        method.addParameter("temp", String.valueOf(this.temp));
        method.addParameter("Sodium", String.valueOf(this.sodiumConc));
        method.addParameter("Magnesium", String.valueOf(this.magnesiumConc));
        method.addParameter("saltunit", "M");
        method.addParameter("filter", "yes");
        float dG = -3.4028235E38f;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new RuntimeException("Http request to DINAMelt web server failed: " + statusCode);
            }
            InputStream in = method.getResponseBodyAsStream();
            if (in != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String tempString = "";
                while ((tempString = r.readLine()) != null) {
                    if (!(tempString = tempString.trim()).startsWith("<tr>")) continue;
                    String[] split = tempString.split("[> ]");
                    dG = Float.parseFloat(split[5]);
                    break;
                }
                if (dG == -3.4028235E38f) {
                    throw new RuntimeException("Error reading results from Mfold server");
                }
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        finally {
            method.releaseConnection();
        }
        log.debug((Object)("dG = " + dG));
        if ((double)dG < this.dGLimit) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Too stable secondary structure", DG_SEC_STRUCT, 2));
        } else if ((double)dG < this.dGLimit + this.dGSpan) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Stable secondary structure", DG_SEC_STRUCT, 1));
        }
    }

    public void reset() {
        this.dGLimit = (Double)this.getData(KEY_DG_LIMIT);
        this.dGSpan = (Double)this.getData(KEY_DG_SPAN);
        this.temp = (Double)this.getData(KEY_FOLD_TEMP);
        this.sodiumConc = (Double)this.getData(KEY_NA_CONC);
        this.magnesiumConc = (Double)this.getData(KEY_MG_CONC);
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

