/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.tc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.plugin.PlugIn;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.calc.ApproximateMeltingPointCalculator;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.calc.NNMeltingPointCalculator;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.TargettedSequence;
import org.moltools.design.data.TargettedSubSequence;
import org.moltools.design.data.impl.TemplateHandler;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.design.utils.ParameterHolder;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.impl.SimpleSequenceEdit;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.struct.DefaultNAHybridStructure;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTSSConstructor
extends AbstractParameterHolder
implements TSSConstructor,
PlugIn {
    protected MeltingPointCalculator defaultMpc;
    protected MeltingPointCalculator backupMpc;
    public static final String PROP_MIN_5_TSS_LENGTH = "MIN_5_PRIME_ARM_LENGTH";
    public static final String PROP_MAX_5_TSS_LENGTH = "MAX_5_PRIME_ARM_LENGTH";
    public static final String PROP_MIN_3_TSS_LENGTH = "MIN_3_PRIME_ARM_LENGTH";
    public static final String PROP_MAX_3_TSS_LENGTH = "MAX_3_PRIME_ARM_LENGTH";
    public static final String PROP_PREF_5_TSS_TEMP = "PREFERRED_5_PRIME_ARM_HYBRIDIZATION_TEMPERATURE";
    public static final String PROP_PREF_3_TSS_TEMP = "PREFERRED_3_PRIME_ARM_HYBRIDIZATION_TEMPERATURE";
    public static final String PROP_5_TSS_TEMP_SPAN = "5_PRIME_ARM_HYBRIDIZATION_TEMPERATURE_SPAN";
    public static final String PROP_3_TSS_TEMP_SPAN = "3_PRIME_ARM_HYBRIDIZATION_TEMPERATURE_SPAN";
    public static final Map<String, String> defaultParameters = new HashMap<String, String>();
    static MessageType messagetype;

    public static String getBriefDescription() {
        return "Target-complementary sequences";
    }

    public static String getLongDescription() {
        return "This constructor creates target-specific sequences that base-pair to the template sequences defined by the target";
    }

    public Map<String, String> getDefaultParameters() {
        return defaultParameters;
    }

    public DefaultTSSConstructor(MeltingPointCalculator m, MeltingPointCalculator backup) {
        this.defaultMpc = m;
        this.backupMpc = backup;
    }

    public DefaultTSSConstructor() {
        try {
            this.defaultMpc = new NNMeltingPointCalculator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.backupMpc = new ApproximateMeltingPointCalculator();
    }

    protected PropertyAcceptorNucleotideSequence constructTSS(TargettedSequence temp, String armDesc, int minlength, double preftemp, byte acidType, byte fixedEnd) {
        PropertyAcceptorNucleotideSequence pa = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence(armDesc, "", acidType), (String)(temp == null ? "" : DesignUtils.getTargetID((PropertyHolder)temp)));
        ChangeableNucleotideSequence cns = (ChangeableNucleotideSequence)pa;
        if (temp == null) {
            return pa;
        }
        try {
            cns.setSequence(NucleotideSequenceHandler.getRevComp((NucleotideSequence)temp, (byte)acidType));
        }
        catch (SequenceFormatException e) {
            throw new UnsupportedOperationException("Invalid sequence");
        }
        if (NucleotideSequenceHandler.countPolys((NucleotideSequence)temp) > 0) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("Could not calculate Tm because of polymorphisms", messagetype, 0));
        } else {
            float Tm;
            if (fixedEnd != 3) {
                boolean done = false;
                String oldseq = pa.seqString();
                float oldTm = 0.0f;
                Tm = 0.0f;
                while (!done) {
                    if (pa.length() == 0) {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("Could not calculate Tm because of zero length", messagetype, 0));
                        return pa;
                    }
                    int secstart = fixedEnd == 2 ? 1 : temp.length() - pa.length() + 1;
                    int secend = fixedEnd == 2 ? pa.length() : temp.length();
                    DefaultNAHybridStructure st = new DefaultNAHybridStructure((Sequence)pa, 1, pa.length(), (Sequence)temp, secstart, secend);
                    oldTm = Tm;
                    Tm = Analyzer.calculateTm((PropertyAcceptorNucleotideSequence)pa, (NucleotideSequence)temp, (NAHybridStructure)st, (MeltingPointCalculator)this.defaultMpc, (MeltingPointCalculator)this.backupMpc);
                    if (pa.length() <= minlength) {
                        done = true;
                        if (!(oldTm > 0.0f) || !(Math.abs((double)Tm - preftemp) > Math.abs((double)oldTm - preftemp))) break;
                        try {
                            cns.setSequence(oldseq);
                            break;
                        }
                        catch (SequenceFormatException e) {
                            throw new UnsupportedOperationException("Invalid sequence");
                        }
                    }
                    if ((double)Tm <= preftemp) {
                        done = true;
                        if (!(oldTm > 0.0f) || !(Math.abs((double)Tm - preftemp) > Math.abs((double)oldTm - preftemp))) break;
                        try {
                            cns.setSequence(oldseq);
                            break;
                        }
                        catch (SequenceFormatException e) {
                            throw new UnsupportedOperationException("Invalid sequence");
                        }
                    }
                    oldseq = pa.seqString();
                    switch (fixedEnd) {
                        case 2: {
                            try {
                                cns.edit((SequenceEdit)new SimpleSequenceEdit(1, 1, ""));
                                break;
                            }
                            catch (SequenceFormatException e) {
                                throw new UnsupportedOperationException("Invalid sequence");
                            }
                        }
                        case 1: {
                            try {
                                cns.edit((SequenceEdit)new SimpleSequenceEdit(pa.length(), 1, ""));
                                break;
                            }
                            catch (SequenceFormatException e) {
                                throw new UnsupportedOperationException("Invalid sequence");
                            }
                        }
                    }
                }
            }
            int secstart = fixedEnd == 1 ? temp.length() - pa.length() + 1 : 1;
            int secend = fixedEnd == 1 ? temp.length() : pa.length();
            DefaultNAHybridStructure st = new DefaultNAHybridStructure((Sequence)pa, 1, pa.length(), (Sequence)temp, secstart, secend);
            ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)pa);
            Tm = Analyzer.calculateTm((PropertyAcceptorNucleotideSequence)pa, (NucleotideSequence)temp, (NAHybridStructure)st, (MeltingPointCalculator)this.defaultMpc, (MeltingPointCalculator)this.backupMpc);
            ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)pa, (float)Tm);
        }
        return pa;
    }

    public PropertyAcceptorNucleotideSequence get3PrimeTSS(ProbeMakerTarget target, byte type) {
        TargettedSubSequence temp;
        double preftemp = Double.parseDouble((String)this.parameters.get(PROP_PREF_3_TSS_TEMP));
        int minlength = Integer.parseInt((String)this.parameters.get(PROP_MIN_3_TSS_LENGTH));
        int maxlength = Integer.parseInt((String)this.parameters.get(PROP_MAX_3_TSS_LENGTH));
        byte fixedEnd = target.getThreePrimeFixedEnd();
        try {
            temp = (TargettedSubSequence)target.getTemplateCluster().getSequence("THREE_PRIME");
        }
        catch (ClusterException e) {
            temp = null;
        }
        Object sub = null;
        if (temp != null) {
            sub = fixedEnd != 3 ? TemplateHandler.subTemplate((TargettedSubSequence)temp, (int)maxlength, (byte)fixedEnd) : temp;
        }
        PropertyAcceptorNucleotideSequence pa = this.constructTSS((TargettedSequence)sub, "3-prime arm", minlength, preftemp, type, fixedEnd);
        return pa;
    }

    public PropertyAcceptorNucleotideSequence get5PrimeTSS(ProbeMakerTarget target, byte type) {
        TargettedSubSequence temp;
        double preftemp = Double.parseDouble((String)this.parameters.get(PROP_PREF_5_TSS_TEMP));
        int minlength = Integer.parseInt((String)this.parameters.get(PROP_MIN_5_TSS_LENGTH));
        int maxlength = Integer.parseInt((String)this.parameters.get(PROP_MAX_5_TSS_LENGTH));
        byte fixedEnd = target.getFivePrimeFixedEnd();
        try {
            temp = (TargettedSubSequence)target.getTemplateCluster().getSequence("FIVE_PRIME");
        }
        catch (ClusterException e) {
            temp = null;
        }
        Object sub = null;
        if (temp != null) {
            sub = fixedEnd != 3 ? TemplateHandler.subTemplate((TargettedSubSequence)temp, (int)maxlength, (byte)fixedEnd) : temp;
        }
        PropertyAcceptorNucleotideSequence pa = this.constructTSS((TargettedSequence)sub, "5-prime arm", minlength, preftemp, type, fixedEnd);
        return pa;
    }

    public void addParameters(Map<String, String> p) {
        super.addParameters(p);
        if (this.defaultMpc instanceof ParameterHolder) {
            ((ParameterHolder)this.defaultMpc).addParameters(p);
        }
    }

    public void setParameters(Map<String, String> p) {
        super.setParameters(p);
        if (this.defaultMpc instanceof ParameterHolder) {
            ((ParameterHolder)this.defaultMpc).setParameters(p);
        }
    }

    static {
        defaultParameters.put(PROP_MIN_5_TSS_LENGTH, "15");
        defaultParameters.put(PROP_MAX_5_TSS_LENGTH, "25");
        defaultParameters.put(PROP_MIN_3_TSS_LENGTH, "15");
        defaultParameters.put(PROP_MAX_3_TSS_LENGTH, "25");
        defaultParameters.put(PROP_PREF_5_TSS_TEMP, "50");
        defaultParameters.put(PROP_PREF_3_TSS_TEMP, "50");
        defaultParameters.put(PROP_5_TSS_TEMP_SPAN, "10");
        defaultParameters.put(PROP_3_TSS_TEMP_SPAN, "10");
        messagetype = new MessageType("TEMPERATURE_CALCULATION", "Temperature calculation");
    }
}

