/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import edu.stanford.disperse.RunTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import net.genefront.piecemaker.io.TargetTextTableFormatter;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.variation.Variation;
import net.genefront.piecemaker.variation.VariationUtils;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.design.properties.PropertySet;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.alphabet.Nucleotide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSubstitutions
extends RunTarget {
    protected static Options createOptions() {
        Options options = new Options();
        options.addOption(targetOption);
        options.addOption(variationOption);
        options.addOption("o", true, "Output file");
        options.addOption(helpOption);
        return options;
    }

    public AddSubstitutions() {
        super("addsubs", AddSubstitutions.createOptions());
    }

    public static void main(String[] args) {
        try {
            AddSubstitutions runner = new AddSubstitutions();
            if (runner.parseCommandLine(args)) {
                if (!runner.commandLine.hasOption("t")) {
                    AddSubstitutions.error("No target file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                if (!runner.commandLine.hasOption("v")) {
                    AddSubstitutions.error("No variation file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                File outputfile = null;
                if (runner.commandLine.hasOption("o")) {
                    outputfile = new File(runner.commandLine.getOptionValue("o"));
                }
                File targetfile = new File(runner.commandLine.getOptionValue("t"));
                File variationfile = new File(runner.commandLine.getOptionValue("v"));
                if (!targetfile.canRead()) {
                    AddSubstitutions.error("Target file does not exist: " + targetfile.getAbsolutePath());
                    System.exit(1);
                }
                if (!variationfile.canRead()) {
                    AddSubstitutions.error("Variation file does not exist: " + variationfile.getAbsolutePath());
                    System.exit(1);
                }
                if (outputfile != null && !outputfile.getAbsoluteFile().getParentFile().canWrite()) {
                    AddSubstitutions.error("Output file can not be written: " + outputfile.getAbsolutePath());
                    System.exit(1);
                }
                PrintWriter pw = outputfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputfile));
                FileReader r = new FileReader(targetfile);
                BufferedReader br = new BufferedReader(r);
                String line = null;
                while ((line = br.readLine()).startsWith("#")) {
                    pw.println(line);
                }
                br.close();
                Collection<SelectorTarget> targets = runner.readTargets(targetfile);
                System.out.println("Adding substitutions to " + targets.size() + " targets from " + targetfile.getAbsolutePath());
                Collection variations = VariationUtils.readVariations((Reader)new FileReader(variationfile));
                System.out.println("Loaded " + variations.size() + " variations from " + variationfile.getAbsolutePath());
                CollectionUtils.filter((Collection)variations, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return VariationUtils.isSubstitution((Variation)((Variation)object));
                    }
                });
                System.out.println("Using " + variations.size() + " substitutions");
                TargetTextTableFormatter formatter = new TargetTextTableFormatter();
                for (SelectorTarget target : targets) {
                    SelectorTarget newTarget = AddSubstitutions.getTargetWithVariations(target, variations);
                    formatter.writeSequence(pw, (Sequence)newTarget);
                }
                System.out.println("Done");
                pw.close();
            }
        }
        catch (Exception ex) {
            AddSubstitutions.error(ex.getMessage(), ex);
            System.exit(1);
        }
    }

    protected static SelectorTarget getTargetWithVariations(final SelectorTarget target, Collection<Variation> variations) {
        Collection varsInTarget = CollectionUtils.select(variations, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Variation var = (Variation)object;
                String parentID = var.getParentID();
                if (!parentID.equals(target.getParentID())) {
                    return false;
                }
                int up = var.getReferenceUpstreamPosition();
                int down = var.getReferenceDownstreamPosition();
                if (up + 1 < target.getStart()) {
                    return false;
                }
                return down - 1 <= target.getEnd();
            }
        });
        String newSeq = VariationUtils.addSubstitutions((SelectorTarget)target, (Collection)varsInTarget);
        DelegatingTarget newTarget = new DelegatingTarget(target, newSeq);
        return newTarget;
    }

    public static class DelegatingTarget
    implements SelectorTarget {
        private SelectorTarget target;
        private String newSeq;

        public DelegatingTarget(SelectorTarget target, String newSeq) {
            this.target = target;
            this.newSeq = newSeq;
        }

        public int getEnd() {
            return this.target.getEnd();
        }

        public String getID() {
            return this.target.getID();
        }

        public Nucleotide getNucleotideAt(int ntpos) {
            throw new UnsupportedOperationException();
        }

        public String getParentID() {
            return this.target.getParentID();
        }

        public byte getPolarity() {
            return this.target.getPolarity();
        }

        public PropertySet getPropertySet() {
            return this.target.getPropertySet();
        }

        public int getStart() {
            return this.target.getStart();
        }

        public byte getType() {
            return this.target.getType();
        }

        public int length() {
            return this.target.length();
        }

        public String seqString() {
            return this.newSeq;
        }

        public String subsequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }
}

