/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import net.genefront.piecemaker.io.TargetTextTableFormatter;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.model.impl.SimpleSelectorTarget;
import net.sf.apptools.textio.ObjectBuilder;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.utils.SequenceIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunTarget {
    public static final String TARGET_FILE_OPTION = "t";
    public static final String VARIATION_FILE_OPTION = "v";
    public static final String SETTINGS_FILE_OPTION = "s";
    public static final String OUTPUT_FILE_OPTION = "o";
    public static final String FRAGMENT_FILE_OPTION = "f";
    public static final String HELP_OPTION = "h";
    static final Option helpOption = new Option("h", "Print help text");
    static final Option targetOption = new Option("t", true, "Path to target file");
    static final Option variationOption;
    static final Option settingsOption;
    static Log log;
    private final String name;
    private final Options commandLineOptions;
    protected CommandLine commandLine;

    protected static void error(String message) {
        RunTarget.error(message, null);
    }

    protected static void error(String message, Throwable cause) {
        log.error((Object)message, cause);
        System.err.println(message);
        System.err.println("Check java log for errors [disperse_java.log]");
    }

    public RunTarget(String name, Options clOptions) {
        this.name = name;
        this.commandLineOptions = clOptions;
    }

    public String getName() {
        return this.name;
    }

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getName(), this.commandLineOptions);
    }

    protected boolean parseCommandLine(String[] arguments) {
        BasicParser parser = new BasicParser();
        try {
            this.commandLine = parser.parse(this.commandLineOptions, arguments);
        }
        catch (ParseException exp) {
            RunTarget.error("Error parsing command line", exp);
            System.err.println(exp.getMessage());
            this.printHelp();
            return false;
        }
        if (this.commandLine.hasOption(HELP_OPTION)) {
            this.printHelp();
            return false;
        }
        return true;
    }

    public Collection<SelectorTarget> readTargets(File targetfile) throws FileNotFoundException, IOException, SequenceFormatException {
        TargetTextTableFormatter formatter = new TargetTextTableFormatter();
        List targets = SequenceIO.readSequences((Reader)new FileReader(targetfile), (SequenceDataReader)formatter, (ObjectBuilder)SimpleSelectorTarget.defaultBuilder);
        return targets;
    }

    static {
        targetOption.setArgName("target file");
        variationOption = new Option(VARIATION_FILE_OPTION, true, "Path to filtered variation file");
        variationOption.setArgName("variation file");
        settingsOption = new Option(SETTINGS_FILE_OPTION, true, "Path to design settings file");
        settingsOption.setArgName("settings file");
        log = LogFactory.getLog((String)"piecemaker-cli");
    }
}

