/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Setup {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            throw new UnsupportedOperationException("No descriptor file specified");
        }
        File descriptor = new File(args[0]);
        Map<String, String> cfgMap = Setup.getConfigMap(descriptor);
        String[] libPaths = cfgMap.containsKey("libpath") ? cfgMap.get("libpath").split(",") : new String[]{};
        String[] vmArgs = cfgMap.containsKey("vmarg") ? cfgMap.get("vmarg").split(",") : new String[]{};
        String[] additionalClasspaths = cfgMap.containsKey("file") ? cfgMap.get("file").split(",") : new String[]{};
        String[] appArgs = cfgMap.containsKey("apparg") ? cfgMap.get("apparg").split(",") : new String[]{};
        String mainClass = cfgMap.get("mainclass");
        String name = cfgMap.get("name");
        File bat = new File(name + ".bat");
        File sh = new File(name + ".sh");
        File[] libDirs = Setup.createFiles(libPaths);
        File[] additional = Setup.createFiles(additionalClasspaths);
        String classPathWin = Setup.buildClassPath(libDirs, additional, ";");
        String classPathLinux = Setup.buildClassPath(libDirs, additional, ":");
        String commandLineWin = Setup.buildCommandLine(null, vmArgs, classPathWin, mainClass, appArgs);
        PrintWriter pw = new PrintWriter(new FileWriter(bat));
        pw.println("@echo off");
        pw.println("set APPARGS=%1");
        pw.println(":addarg");
        pw.println("shift");
        pw.println("if \"\"==\"%1\" goto end");
        pw.println("set APPARGS=%APPARGS% %1");
        pw.println("goto addarg");
        pw.println(":end");
        pw.println(commandLineWin + " %APPARGS%");
        pw.close();
        String commandLineLinux = Setup.buildCommandLine(null, vmArgs, classPathLinux, mainClass, appArgs);
        pw = new PrintWriter(new FileWriter(sh));
        pw.println(commandLineLinux + " $@");
        pw.close();
        File extlib = new File("extlib");
        File configFile = new File("config/apptools/platform.properties");
        FileWriter fw = new FileWriter(configFile, true);
        String pathString = extlib.getAbsolutePath();
        fw.write("\n");
        fw.write("apptools.platform.extensionDir=" + pathString.replace('\\', '/'));
        fw.write("\n");
        fw.close();
        System.exit(0);
    }

    private static Map<String, String> getConfigMap(File descriptor) throws IOException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(descriptor));
        String line = null;
        int lineNo = 0;
        while ((line = br.readLine()) != null) {
            line = line.trim();
            ++lineNo;
            if (line.startsWith("#") || line.length() <= 0) continue;
            String[] split = line.split("[:=]");
            if (split.length != 2) {
                throw new IOException("Malformed entry on line " + lineNo);
            }
            String key = split[0].trim();
            String newValue = split[1].trim();
            String oldValue = (String)configMap.get(key);
            configMap.put(key, oldValue == null ? newValue : oldValue + "," + newValue);
        }
        return configMap;
    }

    static String buildClassPath(File[] jarDirs, File[] other, String pathSep) throws FileNotFoundException {
        StringBuffer cp = new StringBuffer();
        if (jarDirs != null) {
            for (int d = 0; d < jarDirs.length; ++d) {
                File[] jars = jarDirs[d].listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                if (jars == null) continue;
                for (int f = 0; f < jars.length; ++f) {
                    String path = jars[f].getAbsolutePath();
                    if (!jars[f].exists()) {
                        throw new FileNotFoundException(path);
                    }
                    if (path.indexOf(32) > 0) {
                        cp.append("\"" + path + "\"");
                    } else {
                        cp.append(path);
                    }
                    cp.append(pathSep);
                }
            }
        }
        if (other != null) {
            for (int f = 0; f < other.length; ++f) {
                String path = other[f].getAbsolutePath();
                if (!other[f].exists()) {
                    throw new FileNotFoundException(path);
                }
                if (path.indexOf(32) > 0) {
                    cp.append("\"" + path + "\"");
                } else {
                    cp.append(path);
                }
                cp.append(pathSep);
            }
        }
        return cp.length() == 0 ? cp.toString() : cp.replace(cp.length() - pathSep.length(), cp.length(), "").toString();
    }

    static String buildCommandLine(String java, String[] vmArgs, String classPath, String mainClass, String[] appArgs) {
        int a;
        StringBuffer cl = new StringBuffer();
        cl.append(java != null ? java : "java");
        if (vmArgs != null) {
            for (a = 0; a < vmArgs.length; ++a) {
                cl.append(" " + vmArgs[a]);
            }
        }
        if (classPath != null) {
            cl.append(" -classpath " + classPath);
        }
        cl.append(" " + mainClass);
        if (appArgs != null) {
            for (a = 0; a < appArgs.length; ++a) {
                cl.append(" " + appArgs[a]);
            }
        }
        return cl.toString();
    }

    static File[] createFiles(String[] paths) throws FileNotFoundException {
        File[] files = new File[paths.length];
        for (int f = 0; f < files.length; ++f) {
            files[f] = new File(paths[f]).getAbsoluteFile();
            if (files[f].exists()) continue;
            throw new FileNotFoundException(files[f].getAbsolutePath());
        }
        return files;
    }
}

