/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.console;

import java.io.PrintStream;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.console.Command;
import net.sf.apptools.console.CommandInterpreter;
import net.sf.apptools.console.CommandSet;
import net.sf.apptools.console.VariableOption;

public class CommandParser {
    CommandSet commands;
    CommandInterpreter interpreter;

    public CommandParser(CommandSet commands, CommandInterpreter interpreter) {
        this.commands = commands;
        this.interpreter = interpreter;
    }

    public void parseCommand(String line, PrintStream console) {
        if (line.length() == 0) {
            console.println(CommandParser.getCommandList(this.commands.getCommands(), 2));
            return;
        }
        String[] tokens = line.split(" ");
        int toks = tokens.length;
        if (toks > 0) {
            boolean OK = true;
            Command[] comms = CommandSet.getCommands(this.commands.getCommands(), tokens[0]);
            if (comms.length < 1) {
                console.println(PlatformTexts.getString("CommandParser.MESSAGE_NO_COMMAND"));
                OK = false;
            } else if (comms.length > 1) {
                console.println(PlatformTexts.getString("CommandParser.MESSAGE_AMBIGUOUS_COMMAND"));
                OK = false;
            } else {
                Command command;
                Command last = command = comms[0];
                Command.Option[] options = new Command.Option[toks - 1];
                StringBuffer comStr = new StringBuffer(command.getName());
                for (int t = 1; t < toks; ++t) {
                    Command.Option opt;
                    String tok = tokens[t];
                    Command[] opts = CommandSet.getCommands(last.getOptions(), tok);
                    if (opts.length < 1) {
                        if (CommandParser.hasNonStrictOption(last)) {
                            options[t - 1] = opt = new VariableOption(tok);
                            comStr.append(" " + opt.getName());
                            last = opt;
                            continue;
                        }
                        console.println(comStr + " " + PlatformTexts.getString("CommandParser.MESSAGE_NO_OPTION"));
                        OK = false;
                        break;
                    }
                    if (opts.length > 1) {
                        console.println(comStr + " " + PlatformTexts.getString("CommandParser.MESSAGE_AMBIGUOUS_OPTION"));
                        OK = false;
                        break;
                    }
                    opt = (Command.Option)opts[0];
                    comStr.append(" " + opt.getName());
                    options[t - 1] = opt;
                    last = opt;
                }
                if (OK) {
                    console.println(comStr.toString());
                    byte result = this.interpreter.interpret(command, options);
                    switch (result) {
                        case 1: {
                            break;
                        }
                        case -2: {
                            console.println(PlatformTexts.getString("CommandParser.ERROR_EXECUTION"));
                            break;
                        }
                        case -1: {
                            console.println(PlatformTexts.getString("CommandParser.ERROR_PARSING_COMMAND"));
                            break;
                        }
                        case 0: {
                            console.println(PlatformTexts.getString("CommandParser.ERROR_INCOMPLETE_COMMAND"));
                            console.println(CommandParser.getOptionList(command.getOptions(), 2));
                        }
                    }
                }
            }
        }
    }

    static boolean hasNonStrictOption(Command c) {
        Command.Option[] options = c.getOptions();
        boolean has = false;
        for (int i = 0; i < options.length; ++i) {
            if (options[i].isStrict()) continue;
            has = true;
            break;
        }
        return has;
    }

    public static String getCommandList(Command[] commands, int indent) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < commands.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                str.append(" ");
            }
            str.append(commands[i].getName());
            str.append("\t\t");
            str.append(commands[i].getBrief());
            str.append("\n");
        }
        return str.toString();
    }

    protected static String getCommandDescription(Command c, int indent) {
        StringBuffer str = new StringBuffer();
        for (int j = 0; j < indent; ++j) {
            str.append(" ");
        }
        str.append(c.getName());
        str.append("\t\t");
        str.append(c.getBrief());
        str.append("\n");
        str.append(CommandParser.getOptionList(c.getOptions(), indent + 2));
        return str.toString();
    }

    protected static String getOptionList(Command.Option[] options, int indent) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            for (int j = 0; j < indent; ++j) {
                str.append(" ");
            }
            str.append(options[i].getName());
            str.append("\t\t");
            str.append(options[i].getBrief());
            str.append("\n");
            str.append(CommandParser.getOptionList(options[i].getOptions(), indent + 2));
        }
        return str.toString();
    }
}

