/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.apptools.graph.ChangeableGraph;
import net.sf.apptools.graph.GraphEdge;
import net.sf.apptools.graph.GraphVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGraph
implements ChangeableGraph {
    protected Set<GraphEdge> edges = new HashSet<GraphEdge>();
    protected Set<GraphVertex> vertices = new HashSet<GraphVertex>();

    @Override
    public Collection<GraphEdge> getEdges() {
        return Collections.unmodifiableCollection(this.edges);
    }

    @Override
    public Collection<GraphVertex> getVertices() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    @Override
    public void addEdge(GraphEdge e) {
        this.edges.add(e);
        for (GraphVertex v : e.getVertices()) {
            v.addEdge(e);
        }
    }

    @Override
    public void addVertex(GraphVertex v) {
        this.vertices.add(v);
    }

    @Override
    public void removeEdge(GraphEdge e) {
        this.edges.remove(e);
        for (GraphVertex v : e.getVertices()) {
            v.removeEdge(e);
        }
    }

    @Override
    public void removeVertex(GraphVertex v) {
        this.vertices.remove(v);
        Iterator<GraphEdge> i = v.getEdges().iterator();
        while (i.hasNext()) {
            this.removeEdge(i.next());
        }
    }
}

