/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataHolder
implements DataHolder {
    protected DataDescriptor[] dataDescriptors;
    protected Map<String, Object> dataValues;

    public DefaultDataHolder(DataDescriptor[] descriptors) {
        this.dataDescriptors = descriptors;
        if (this.dataDescriptors == null) {
            this.dataDescriptors = new DataDescriptor[0];
        }
        this.dataValues = new HashMap<String, Object>();
    }

    public DefaultDataHolder(DataDescriptor[] descriptors, Map<String, ? extends Object> objects) {
        this(descriptors);
        this.setData(objects);
    }

    public DefaultDataHolder(DataDescriptor[] descriptors, Object[] values) {
        this(descriptors);
        DataHolderUtils.putOrderedData(values, this);
    }

    @Override
    public DataDescriptor[] getDataDescriptors() {
        return this.dataDescriptors;
    }

    @Override
    public Map<String, Object> getData() {
        return this.dataValues;
    }

    @Override
    public Object getData(String propName) {
        return this.dataValues.get(propName);
    }

    @Override
    public void setData(Map<String, ?> values) {
        for (Map.Entry<String, ?> e : values.entrySet()) {
            this.setData(e.getKey(), e.getValue());
        }
    }

    @Override
    public void setData(String key, Object newValue) {
        DataDescriptor dd = DataHolderUtils.getDescriptorForKey(this, key);
        if (dd == null) {
            throw new IllegalArgumentException("No such key: " + key);
        }
        if (newValue == null) {
            this.dataValues.put(key, null);
        } else if (dd.getDataType().isAssignableFrom(newValue.getClass())) {
            this.dataValues.put(key, newValue);
        } else {
            Class<?> type = newValue.getClass();
            Converter toValueConverter = DataHolderUtils.getToValueConverter(dd);
            if (toValueConverter == null) {
                throw new RuntimeException("No Converter found for " + type);
            }
            this.setData(dd.getKey(), toValueConverter.convert(type, newValue));
        }
    }
}

