/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import net.sf.apptools.data.AbstractDataDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDescriptor
extends AbstractDataDescriptor {
    double lowerLimit;
    double upperLimit;

    public DoubleDescriptor(String name, String description, String propertyName, double lower, double upper) {
        super(name, description, propertyName, true);
        this.lowerLimit = lower;
        this.upperLimit = upper;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public Class<?> getDataType() {
        return new Double(0.0).getClass();
    }

    protected Object getValue(Object valueRepr) {
        if (valueRepr instanceof Double) {
            return valueRepr;
        }
        return new Double(valueRepr.toString());
    }

    @Override
    public String validate(Object obj) {
        if (obj == null) {
            return "No input for '" + this.getName() + "'";
        }
        Double i = (Double)this.getValue(obj);
        double input = i;
        if (this.lowerLimit <= input && input <= this.upperLimit) {
            return null;
        }
        return "'" + this.getName() + "' should be [" + this.lowerLimit + ", " + this.upperLimit + "]";
    }
}

