/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.text.JTextComponent;
import net.sf.apptools.utils.HTMLWriter;
import org.apache.commons.logging.Log;

public abstract class MessageLog {
    public abstract void sendMessage(String var1);

    public static MessageLog getSystemOutLog() {
        return new MessageLog(){

            public void sendMessage(String mess) {
                System.out.println(mess);
            }
        };
    }

    public static MessageLog getSystemErrLog() {
        return new MessageLog(){

            public void sendMessage(String mess) {
                System.err.println(mess);
            }
        };
    }

    public static MessageLog getPrintStreamLog(final PrintStream ps) {
        return new MessageLog(){

            public void sendMessage(String mess) {
                ps.println(mess);
            }
        };
    }

    public static MessageLog getLoggerLog(final Log log) {
        return new MessageLog(){

            public void sendMessage(String str) {
                log.info((Object)str);
            }
        };
    }

    public static MessageLog getTextComponentLog(final JTextComponent log) {
        return new MessageLog(){

            public void sendMessage(String str) {
                log.setText(log.getText() + str + "\n");
                log.setCaretPosition(log.getText().length());
            }
        };
    }

    public static MessageLog getHTMLLog(PrintWriter pw) {
        final HTMLWriter writer = new HTMLWriter(pw);
        return new MessageLog(){

            public void sendMessage(String str) {
                writer.println(str);
            }
        };
    }
}

