/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.apptools.textio.DataMapInput;
import net.sf.apptools.textio.ObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputIterator<T>
implements Iterator<T> {
    protected T buffer = null;
    protected DataMapInput input;
    protected ObjectBuilder<? extends T> builder;

    public InputIterator(Reader reader, DataMapInput input, ObjectBuilder<? extends T> builder) {
        this.input = input;
        this.builder = builder;
        input.setReader(reader);
        try {
            this.buffer = this.getNextObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected T getNextObject() throws IOException {
        Map<String, String> data = this.input.getNextDataMap();
        if (data == null) {
            return null;
        }
        return this.builder.buildObject(data);
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null;
    }

    @Override
    public T next() {
        if (this.buffer == null) {
            throw new NoSuchElementException();
        }
        T o = this.buffer;
        try {
            this.buffer = this.getNextObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator is read-only");
    }
}

