/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.messages;

import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.messages.MessageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
implements Comparable<Message> {
    public static final String[] messageSeverityDescriptions = new String[]{CoreMessages.getString("Message.SEVERITY_ALERT"), CoreMessages.getString("Message.SEVERITY_WARNING"), CoreMessages.getString("Message.SEVERITY_ERROR"), CoreMessages.getString("Message.SEVERITY_FATAL")};
    public static final byte ALERT = 0;
    public static final byte WARNING = 1;
    public static final byte ERROR = 2;
    public static final byte FATAL = 3;
    protected String message;
    protected MessageType type;
    protected byte severity;

    public Message(String _message, MessageType _type, byte _severity) {
        this.message = _message;
        this.type = _type;
        this.severity = _severity;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getType() {
        return this.type;
    }

    public byte getSeverity() {
        return this.severity;
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public int compareTo(Message m) {
        if (this.severity < m.getSeverity()) {
            return -1;
        }
        if (this.severity > m.getSeverity()) {
            return 1;
        }
        if (this.type != m.getType()) {
            return -1;
        }
        int result = this.message.compareTo(m.getMessage());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

