/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.moltools.apps.probemaker.seq.Polymorphism;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.apps.probemaker.seq.impl.InDel;
import org.moltools.apps.probemaker.seq.impl.SNP;
import org.moltools.apps.probemaker.seq.impl.VariationSequenceElementContainer;
import org.moltools.design.data.SequenceElementContainer;
import org.moltools.design.data.TargettedSequence;
import org.moltools.design.data.impl.DefaultPropertySet;
import org.moltools.design.properties.MutablePropertySet;
import org.moltools.design.properties.PropertySet;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceCluster;
import org.moltools.lib.seq.SequenceElement;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.impl.MapCluster;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComplexTarget
extends VariationSequenceElementContainer
implements VariantTarget,
SequenceElementContainer,
SequenceView,
ProbeMakerTarget {
    public static final char positionSymbol = '|';
    protected int targetPoly;
    protected int variantIndex;
    protected TargettedSequence pat5;
    protected TargettedSequence pat3;
    protected MutablePropertySet propertySet = new DefaultPropertySet();

    public AbstractComplexTarget() {
        this(0);
    }

    public AbstractComplexTarget(byte _type) {
        this("", "", _type);
    }

    public AbstractComplexTarget(String id, String seq, byte type) {
        this(id, seq, "", type);
    }

    public AbstractComplexTarget(String id, String seq, String description, byte type) {
        super(id, type);
        this.description = description;
        this.sequence = new ArrayList();
        try {
            this.setSequence(seq);
        }
        catch (SequenceFormatException sfx) {
            sfx.printStackTrace();
        }
    }

    public AbstractComplexTarget(NucleotideSequence _seq) {
        this(_seq.getID(), _seq.seqString(), _seq.getType());
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public MutablePropertySet getMutablePropertySet() {
        return this.propertySet;
    }

    public String getViewName() {
        if (this.getName() == null) {
            return this.getID();
        }
        return this.getName().length() == 0 ? this.getID() : this.getName();
    }

    protected final void setProbeArmTemplates() {
        try {
            this.setTemplateForFivePrimeArm();
            this.setTemplateForThreePrimeArm();
        }
        catch (UnsupportedOperationException ex) {
            this.pat5 = null;
            this.pat3 = null;
        }
    }

    protected abstract void setTemplateForFivePrimeArm();

    protected abstract void setTemplateForThreePrimeArm();

    public SequenceCluster<NucleotideSequence> getTemplateCluster() {
        MapCluster sc = new MapCluster();
        try {
            sc.putSequence("FIVE_PRIME", (Sequence)this.pat5);
            sc.putSequence("THREE_PRIME", (Sequence)this.pat3);
        }
        catch (ClusterException clusterException) {
            // empty catch block
        }
        return sc;
    }

    public boolean isValid(String seq, byte type1) {
        try {
            ArrayList<SequenceElement> elements = new ArrayList<SequenceElement>();
            this.parse(seq, type1, elements);
            Iterator<SequenceElement> i = elements.iterator();
            while (i.hasNext()) {
                if (!(i.next() instanceof Polymorphism)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean isValidPoly(String seq, byte type1) {
        try {
            for (int i = 0; i < seq.length(); ++i) {
                Nucleotide nt = NucleotideSequenceHandler.getNucleotide((char)seq.charAt(i), (byte)this.getType());
                if (nt != null) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    @Override
    public String parse(String seq, byte acidType, List<SequenceElement> elements) throws SequenceFormatException {
        elements.clear();
        Stack<VariationSequenceElementContainer> elementStack = new Stack<VariationSequenceElementContainer>();
        VariationSequenceElementContainer root = new VariationSequenceElementContainer("", acidType);
        elementStack.push(root);
        boolean inSNP = false;
        boolean foundPos = false;
        if (this.targetPoly == 0) {
            this.variantIndex = -1;
        }
        int SNPno = 0;
        int InDelno = 0;
        Stack<Nucleotide> SNPNucleotides = new Stack<Nucleotide>();
        char current = ' ';
        for (int pos = 0; pos < seq.length(); ++pos) {
            SequenceElementContainer e;
            char previous = current;
            current = seq.charAt(pos);
            if (current == '|') {
                if (!foundPos) {
                    foundPos = true;
                    this.targetPoly = 0;
                    this.variantIndex = pos;
                    continue;
                }
                if (!foundPos) continue;
                throw new SequenceFormatException("Too many position symbols");
            }
            if (current == '/') {
                Nucleotide nextnt;
                try {
                    nextnt = NucleotideSequenceHandler.getNucleotide((char)seq.charAt(pos + 1), (byte)acidType);
                }
                catch (StringIndexOutOfBoundsException sx) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + (pos + 2));
                }
                Nucleotide prevnt = NucleotideSequenceHandler.getNucleotide((char)previous, (byte)acidType);
                if (prevnt == null) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + pos);
                }
                if (nextnt == null) {
                    throw new SequenceFormatException("Expected nucleotide at position: " + (pos + 2));
                }
                if (inSNP) {
                    SNPNucleotides.push(nextnt);
                } else {
                    SNPNucleotides.push(prevnt);
                    SNPNucleotides.push(nextnt);
                    inSNP = true;
                    SequenceElementContainer e2 = (SequenceElementContainer)elementStack.peek();
                    e2.removeFromEnd();
                }
                ++pos;
                int next = 32;
                try {
                    next = seq.charAt(pos + 1);
                }
                catch (StringIndexOutOfBoundsException sx2) {
                    // empty catch block
                }
                if (next == 47) continue;
                Nucleotide[] nucs = new Nucleotide[SNPNucleotides.size()];
                for (int i = 0; i < nucs.length; ++i) {
                    nucs[i] = (Nucleotide)SNPNucleotides.pop();
                }
                SNP snp = new SNP(nucs, "SNP " + ++SNPno);
                SequenceElementContainer e3 = (SequenceElementContainer)elementStack.peek();
                e3.addToEnd((SequenceElement)snp);
                inSNP = false;
                continue;
            }
            if (current == '[') {
                elementStack.push(new InDel("InDel " + ++InDelno, "", "InDel " + ++InDelno, acidType));
                continue;
            }
            if (current == ']') {
                if (elementStack.size() < 2) {
                    throw new SequenceFormatException("Too many InDel end symbols");
                }
                InDel indel = (InDel)elementStack.pop();
                e = (SequenceElementContainer)elementStack.peek();
                e.addToEnd((SequenceElement)indel);
                continue;
            }
            Nucleotide n = NucleotideSequenceHandler.getNucleotide((char)current, (byte)acidType);
            if (n == null) {
                throw new SequenceFormatException("Invalid symbol encountered during sequence parsing: " + current);
            }
            if (NucleotideSequenceHandler.isPoly((Nucleotide)n)) {
                SNP snp = new SNP(((DegenerateNucleotide)n).getPossible(), "SNP" + ++SNPno);
                SequenceElementContainer e4 = (SequenceElementContainer)elementStack.peek();
                e4.addToEnd((SequenceElement)snp);
                continue;
            }
            e = (SequenceElementContainer)elementStack.peek();
            e.addToEnd((SequenceElement)n);
        }
        elements.addAll(root.getElements());
        String seqString = AbstractComplexTarget.sequenceOf(elements);
        return seqString;
    }

    public boolean isValid() {
        return this.isValid(this.seqString(), this.type);
    }

    public boolean isValidPoly() {
        return this.isValidPoly(this.seqString(), this.type);
    }

    public int countPolys() {
        int polycount = 0;
        Iterator i = this.sequence.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof Polymorphism)) continue;
            ++polycount;
        }
        return polycount;
    }

    public Polymorphism[] getPolys() {
        Polymorphism[] polys = new Polymorphism[this.countPolys()];
        int polypos = 0;
        for (SequenceElement e : this.sequence) {
            if (!(e instanceof Polymorphism)) continue;
            polys[polypos++] = (Polymorphism)e;
        }
        return polys;
    }
}

