/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.impl.AbstractProbe;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProbe
extends AbstractProbe {
    public static SequenceBuilder<Probe> getSequenceBuilder() {
        return new SequenceBuilder<Probe>(){

            public Probe buildObject(Map<String, String> props) {
                String name = props.get("sequence.name");
                String id = props.get("ID");
                String seqstr = props.get("sequence.seqstring");
                ArrayList<String> l = new ArrayList<String>();
                ArrayList<SimpleChangeableNucleotideSequence> tags = new ArrayList<SimpleChangeableNucleotideSequence>();
                StringTokenizer st = new StringTokenizer(seqstr, "|");
                while (st.hasMoreTokens()) {
                    l.add(st.nextToken());
                }
                PropertyAcceptorNucleotideSequence tss5 = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleChangeableNucleotideSequence("5' TSS", (String)l.get(0), 0, "5' TSS"), null);
                for (int i = 1; i < l.size() - 1; ++i) {
                    tags.add(new SimpleChangeableNucleotideSequence(id + "|Tag " + i, (String)l.get(i), 0, "Tag " + i));
                }
                PropertyAcceptorNucleotideSequence tss3 = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleChangeableNucleotideSequence("3' TSS", (String)l.get(l.size() - 1), 0, "3' TSS"), null);
                DefaultProbe p = new DefaultProbe(ProbeMakerSequenceFactory.createTSSPair(tss5, tss3, null), 0, 0, 0);
                for (int i = 0; i < tags.size(); ++i) {
                    p.addTagAt((NucleotideSequence)tags.get(i), i);
                }
                p.setName(name);
                p.setID(id);
                p.setTagsAllocated(true);
                return p;
            }
        };
    }

    public DefaultProbe(byte type) {
        this(null, 0, 0, type);
    }

    public DefaultProbe(TSSPair pair, int upstream, int downstream, byte type) {
        super(pair, type);
        this.upstreamBlocks = upstream;
        this.downstreamBlocks = downstream;
    }

    @Override
    public void copy(Probe p) {
        this.setType(p.getType());
        this.setName(p.getName());
        this.setTSSPair(p.getTSSPair());
        this.tags = new ArrayList();
        this.tags.addAll(p.getTags());
        Collection<Message> messages = ProbeMakerPropertyUtils.getOwnMessages(p);
        for (Message m : messages) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)this, m);
        }
        this.upstreamBlocks = ((DefaultProbe)p).upstreamBlocks;
        this.downstreamBlocks = ((DefaultProbe)p).downstreamBlocks;
        this.tagsAllocated = p.tagsAllocated();
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }

    @Override
    public Probe getCopy() {
        DefaultProbe p = new DefaultProbe(this.getType());
        p.copy(this);
        return p;
    }

    @Override
    public int getTagNoOfBlock(int blockno) {
        if (blockno < 1 || blockno > this.getSequenceCount()) {
            return -1;
        }
        if (blockno <= this.upstreamBlocks) {
            return blockno - 1;
        }
        if (blockno == this.upstreamBlocks + 1) {
            return -1;
        }
        if (blockno < this.getSequenceCount() - this.downstreamBlocks) {
            return blockno - 2;
        }
        if (blockno == this.getSequenceCount() - this.downstreamBlocks) {
            return -1;
        }
        return blockno - 3;
    }

    public NucleotideSequence getSequence(int no) {
        int dblocks;
        if (no < 1 || no > this.getSequenceCount()) {
            throw new IllegalArgumentException("No such block (" + no + ")");
        }
        int ublocks = this.getTags().isEmpty() ? 0 : this.upstreamBlocks;
        int n = dblocks = this.getTags().isEmpty() ? 0 : this.downstreamBlocks;
        if (dblocks < 0) {
            dblocks = 0;
        }
        if (no == ublocks + 1) {
            try {
                return this.tssPair == null ? null : (NucleotideSequence)this.tssPair.getSequence("FIVE_PRIME");
            }
            catch (ClusterException e) {
                return null;
            }
        }
        if (no == this.getSequenceCount() - dblocks) {
            try {
                return this.tssPair == null ? null : (NucleotideSequence)this.tssPair.getSequence("THREE_PRIME");
            }
            catch (ClusterException e) {
                return null;
            }
        }
        return this.getTagAt(this.getTagNoOfBlock(no));
    }

    public int getSequenceNumberOf(NucleotideSequence s) {
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            if (s != this.getSequence(i)) continue;
            return i;
        }
        throw new IllegalArgumentException("Sequence is not a subsequence of " + this.getID() + ": " + s.getID());
    }

    @Override
    public int getBlockNoOf5() {
        int ublocks = this.getTags().isEmpty() ? 0 : this.upstreamBlocks;
        return ublocks + 1;
    }

    @Override
    public int getBlockNoOf3() {
        int dblocks;
        int n = dblocks = this.getTags().isEmpty() ? 0 : this.downstreamBlocks;
        if (dblocks < 0) {
            dblocks = 0;
        }
        return this.getSequenceCount() - dblocks;
    }

    @Override
    public int getBlockNoOfTag(int tagno) {
        if (tagno < 0 || tagno >= this.getTags().size()) {
            return -1;
        }
        if (tagno < this.upstreamBlocks) {
            return tagno + 1;
        }
        if (tagno < this.getSequenceCount() - this.downstreamBlocks - 2) {
            return tagno + 2;
        }
        return tagno + 3;
    }
}

