/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import net.sf.apptools.CoreEngine;
import net.sf.apptools.DefaultPlatform;
import net.sf.apptools.Platform;
import net.sf.apptools.plugin.DefaultPlugInManager;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.ui.PlatformUI;
import net.sf.apptools.ui.WorkbenchUI;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.utils.AppUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUILauncher {
    static Log log = LogFactory.getLog(GUILauncher.class);
    public static JWindow splash;
    public static JLabel statusLabel;

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            System.err.println("Could not set the Look and Feel");
            e1.printStackTrace();
        }
    }

    public static JLabel showSplash(ImageIcon splashImage, String launchLabel) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice gd = gs[0];
        Dimension screenSize = gd.getDefaultConfiguration().getBounds().getSize();
        splash = new JWindow();
        splash.setBounds(new Double(screenSize.getWidth()).intValue() / 2 - 100, new Double(screenSize.getHeight()).intValue() / 2 - 275, 200, 150);
        JPanel cp = (JPanel)splash.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.black);
        JLabel startLabel = new JLabel(launchLabel, 0);
        startLabel.setForeground(Color.white);
        statusLabel = new JLabel("", 0);
        statusLabel.setForeground(Color.white);
        cp.add((Component)new JLabel(splashImage, 0), "Center");
        cp.add((Component)startLabel, "North");
        cp.add((Component)statusLabel, "South");
        splash.setVisible(true);
        return statusLabel;
    }

    public static void checkJavaVersion(String version) {
        statusLabel.setText("Checking Java version");
        boolean verOK = AppUtils.checkJavaVersion((String)version);
        if (!verOK) {
            log.error((Object)("Java version " + version + " required: Not found"));
            JOptionPane.showMessageDialog(splash, "Java version " + version + " is required", "Java Version", 2);
        } else {
            log.info((Object)("Java version " + version + " required: OK"));
        }
    }

    public static CoreEngine startEngine(Class<?> prefsClass) {
        statusLabel.setText("Creating Platform");
        DefaultPlugInManager pim = new DefaultPlugInManager();
        Preferences userPrefs = Preferences.userNodeForPackage(GUILauncher.class);
        CoreEngine e = new CoreEngine((PlugInManager)pim, userPrefs);
        return e;
    }

    public static Platform createPlatform(CoreEngine e) {
        DefaultPlatform p;
        block16: {
            statusLabel.setText("Creating Workbench");
            p = new DefaultPlatform(e);
            ResourceBundle configBundle = null;
            try {
                configBundle = ResourceBundle.getBundle("apptools.workbench");
            }
            catch (Throwable t) {
                log.error((Object)"Error accessing apptools.workbench.properties configuration file. Attempting to run without it.");
            }
            if (configBundle == null) {
                configBundle = new ResourceBundle(){

                    @Override
                    protected Object handleGetObject(String key) {
                        if (key.equals("apptools.workbench.title")) {
                            return "AppTools Workbench";
                        }
                        if (key.equals("apptools.workbench.class")) {
                            return "net.sf.apptools.ext.IFrameWorkbenchUI";
                        }
                        return null;
                    }

                    @Override
                    public Enumeration<String> getKeys() {
                        Vector<String> v = new Vector<String>();
                        v.add("apptools.workbench.title");
                        v.add("apptools.workbench.class");
                        return v.elements();
                    }
                };
            }
            try {
                String titleString;
                try {
                    titleString = configBundle.getString("apptools.workbench.title");
                }
                catch (MissingResourceException ex) {
                    log.warn((Object)"Workbench title not set", (Throwable)ex);
                    titleString = "AppTools Workbench";
                }
                String uiClassName = null;
                try {
                    uiClassName = configBundle.getString("apptools.workbench.class");
                    if (!uiClassName.equals("")) {
                        Class uiClass;
                        log.info((Object)("Creating Workbench with class " + uiClassName));
                        Class apiClass = uiClass = p.coreEngine.getClassLoader().loadClass(uiClassName);
                        p.activatePlugIn(apiClass);
                        WorkbenchUI ui = (WorkbenchUI)p.getPlugInInstance(apiClass);
                        ui.setWorkbenchTitle(titleString);
                        if (ui instanceof SwingWorkbenchUI) {
                            SwingWorkbenchUI swui = (SwingWorkbenchUI)ui;
                            String imageFileName = "";
                            try {
                                imageFileName = e.configBundle.getString("apptools.workbench.icon");
                                if (!imageFileName.equals("")) {
                                    BufferedImage image = ImageIO.read(new File(imageFileName));
                                    swui.setIconImage(image);
                                }
                            }
                            catch (MissingResourceException ex) {
                                log.warn((Object)"Workbench icon not set");
                            }
                            catch (IOException ex) {
                                log.error((Object)("Could not load workbench icon from '" + imageFileName + "'"), (Throwable)ex);
                            }
                        }
                        p.setUI((PlatformUI)ui);
                        break block16;
                    }
                    log.warn((Object)"Workbench class not set");
                }
                catch (MissingResourceException ex) {
                    log.warn((Object)"Workbench class not set", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    log.error((Object)("Could not find workbench class '" + uiClassName + "'"), (Throwable)ex);
                }
            }
            catch (Throwable e1) {
                p.handleError(e1.toString(), e1);
            }
        }
        splash.requestFocus();
        return p;
    }

    public static void showWorkbench(Platform p) {
        try {
            splash.dispose();
        }
        catch (Exception e) {
            p.handleError("Error setting up the GUI", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            GUILauncher.setLookAndFeel();
            GUILauncher.showSplash(null, "Launching AppTools Workbench");
            GUILauncher.checkJavaVersion("1.4.2");
            CoreEngine e = GUILauncher.startEngine(GUILauncher.class);
            Platform p = GUILauncher.createPlatform(e);
            statusLabel.setText("Auto-activating plug-ins");
            p.autoActivatePlugIns();
            GUILauncher.showWorkbench(p);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
    }
}

