/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ext;

import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.prefs.PreferencesEntryTree;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.prefs.DefaultPreferencesEditor;
import net.sf.apptools.ui.swing.prefs.PreferencesEditor;
import net.sf.apptools.ui.swing.prefs.TabPreferencesDialog;
import net.sf.apptools.ui.swing.utils.GUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesEditorPlugIn
implements ActivePlugIn {
    Platform platform;

    public static String getBriefDescription() {
        return "Preferences editor";
    }

    public static String getLongDescription() {
        return "Adds a Preferences editing option to the Workbench";
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(SwingWorkbenchUI.class.getName(), "1.0.0");
        return m;
    }

    public void setup(Platform pf) throws PlugInException {
        this.platform = pf;
        final Frame frame = ((SwingWorkbenchUI)this.platform.getPlugInInstance(SwingWorkbenchUI.class)).getFrame();
        if (frame == null) {
            throw new PlugInException("Couldn't find the Workbench");
        }
        String changePrefsCaption = "User preferences...";
        String changePrefsTooltip = "Change user preferences";
        AbstractUserAction changePrefs = new AbstractUserAction(changePrefsCaption, changePrefsTooltip){

            public void execute() {
                Preferences uprefs = PreferencesEditorPlugIn.this.platform.getUserPreferences();
                PreferencesEntryTree tree = PreferencesEditorPlugIn.this.platform.getPreferencesEntries();
                Map nodeMap = tree.getAllNodes();
                PreferencesEditor[] editors = new PreferencesEditor[nodeMap.size()];
                int p = 0;
                for (Map.Entry e : nodeMap.entrySet()) {
                    PreferencesEntryTree.Node n = (PreferencesEntryTree.Node)e.getValue();
                    Preferences up = uprefs.node(uprefs.absolutePath() + (p > 0 ? "/" + n.getName() : ""));
                    editors[p] = new DefaultPreferencesEditor(up, n.getEntries(), p == 0 ? "General" : n.getName(), PreferencesEditorPlugIn.this.platform.getUI().getCurrentPath());
                    ++p;
                }
                TabPreferencesDialog pd = new TabPreferencesDialog(frame, "Preferences", editors, null);
                GUIUtils.checkSize(pd);
                pd.setLocation(GUIUtils.suggestLocation(pd, frame));
                pd.setVisible(true);
            }
        };
        this.platform.addActionSet(new ActionSet(new UserAction[]{changePrefs}, "Options", (ActivePlugIn)this));
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        return true;
    }

    public String getVersion() {
        return "1.0.0";
    }
}

