/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import net.sf.apptools.ui.swing.SwingUITexts;

class DecimalInputVerifier
extends InputVerifier {
    double maxvalue;
    double minvalue;

    public DecimalInputVerifier(double max, double min) {
        this.maxvalue = max;
        this.minvalue = min;
    }

    public boolean verify(JComponent comp) {
        String txt = ((JTextComponent)comp).getText();
        double d = 0.0;
        try {
            d = Double.parseDouble(txt);
        }
        catch (Exception ex) {
            return false;
        }
        if (d > this.maxvalue) {
            return false;
        }
        return !(d < this.minvalue);
    }

    public boolean shouldYieldFocus(JComponent comp) {
        boolean ver = this.verify(comp);
        if (!ver) {
            Color c = comp.getBackground();
            comp.setBackground(Color.red);
            InputVerifier v = comp.getInputVerifier();
            comp.setInputVerifier(null);
            JOptionPane.showMessageDialog(comp, SwingUITexts.getString("DecimalTextField.MESSAGE_INVALID_INPUT") + "[" + this.minvalue + ", " + this.maxvalue + "]", SwingUITexts.getString("DecimalTextField.TITLE_INPUT"), 0);
            comp.setInputVerifier(v);
            comp.setBackground(c);
        }
        return ver;
    }
}

