/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.data.DataEditor;
import net.sf.apptools.ui.swing.utils.GUIUtils;

class FileDataEditor
extends JPanel
implements DataEditor {
    private static final long serialVersionUID = 1L;
    protected static JFileChooser masterFileChooser = new JFileChooser();
    JTextField field;
    JFileChooser fileChooser = masterFileChooser != null ? masterFileChooser : new JFileChooser(new File(""));
    File file = null;

    public FileDataEditor(String name, String desc) {
        this.setLayout(new BoxLayout(this, 2));
        this.field = new JTextField(25);
        this.field.setMaximumSize(this.field.getPreferredSize());
        JLabel label = new JLabel(name + ":");
        label.setToolTipText(desc);
        label.setLabelFor(this.field);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileDataEditor.this.file != null) {
                    FileDataEditor.this.fileChooser.setCurrentDirectory(FileDataEditor.this.file.getParentFile());
                }
                FileDataEditor.this.setValue(GUIUtils.selectFile(FileDataEditor.this.field, FileDataEditor.this.fileChooser, null, FileDataEditor.this.file, SwingUITexts.getString("DefaultDataEditorFactory.CAPTION_SELECT_FILE")));
            }
        });
        this.add(label);
        this.add(Box.createHorizontalGlue());
        this.add(button);
        this.add(this.field);
    }

    public Object getValue() {
        return this.file;
    }

    public void setValue(Object o) {
        if (o instanceof File) {
            this.file = (File)o;
            this.field.setText(this.file.getAbsolutePath());
        } else if (o != null) {
            this.file = new File(o.toString());
            this.field.setText(this.file.getAbsolutePath());
        } else {
            this.file = null;
        }
    }

    public JComponent getEditorComponent() {
        return this;
    }
}

