/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.prefs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.prefs.BackingStoreException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.prefs.PreferencesEditor;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.ui.swing.utils.TabMultiComponentDialog;

public class TabPreferencesDialog
extends TabMultiComponentDialog {
    private static final long serialVersionUID = 1L;
    protected JButton cancelButton = new JButton(PlatformTexts.getString((String)"Common.CAPTION_CANCEL"));
    protected PreferencesEditor[] editors;

    public TabPreferencesDialog(Frame owner, String title, PreferencesEditor[] edits, Icon icon) throws HeadlessException {
        super(owner, title, null, icon);
        this.cancelButton.addActionListener(this);
        this.controlPane.add(Box.createHorizontalStrut(5));
        this.controlPane.add(this.cancelButton);
        this.editors = edits;
        Component[] comps = new Component[this.editors.length];
        for (int i = 0; i < this.editors.length; ++i) {
            comps[i] = this.editors[i].getEditorComponent();
            comps[i].setName(this.editors[i].getTitle());
        }
        this.setupComponents(comps);
        this.pack();
        this.setLocation(GUIUtils.suggestLocation(this, owner));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                this.save();
                this.dispose();
            }
            catch (Exception ex) {
                int option = JOptionPane.showConfirmDialog(this, SwingUITexts.getString("TabPreferencesDialog.MESSAGE_COULD_NOT_SAVE") + "\n" + ex.toString() + "\n" + PlatformTexts.getString((String)"TabPreferencesDialog.QUERY_EXIT"), SwingUITexts.getString("TabPreferencesDialog.TITLE_SAVING"), 0);
                ex.printStackTrace();
                if (option == 0) {
                    this.dispose();
                }
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    protected void setupComponents(Component[] comps) {
        if (comps != null) {
            super.setupComponents(comps);
        }
    }

    protected void save() throws BackingStoreException {
        for (int i = 0; i < this.editors.length; ++i) {
            this.editors[i].savePreferences();
        }
    }
}

