/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.ui.swing.utils.GUIUtils;

public class TabMultiComponentDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JButton okButton;
    protected JTabbedPane tabPane;
    protected JPanel controlPane;
    protected JPanel iconPane = new JPanel(new BorderLayout());

    public TabMultiComponentDialog(Frame owner, String title, Component[] comps, Icon icon) throws HeadlessException {
        super(owner, title, true);
        this.tabPane = new JTabbedPane();
        this.tabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.okButton = new JButton(PlatformTexts.getString((String)"Common.CAPTION_OK"));
        this.okButton.addActionListener(this);
        this.controlPane = new JPanel();
        this.controlPane.setLayout(new BoxLayout(this.controlPane, 2));
        this.controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.controlPane.add(Box.createHorizontalGlue());
        this.controlPane.add(this.okButton);
        this.getContentPane().add((Component)this.controlPane, "Last");
        this.getContentPane().add((Component)this.tabPane, "Center");
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            this.iconPane.add(iconLabel);
            this.iconPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.getContentPane().add((Component)this.iconPane, "Before");
        this.setupComponents(comps);
        if (this.tabPane.getComponentCount() > 0) {
            this.tabPane.setSelectedComponent(this.tabPane.getComponent(0));
        }
        this.pack();
        this.setLocation(GUIUtils.suggestLocation(this, owner));
    }

    protected void setupComponents(Component[] comps) {
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                JPanel p = new JPanel(new FlowLayout(3));
                p.add(comps[i]);
                this.tabPane.add(comps[i].getName(), p);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }
}

