/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.AllawiNNParameters;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.calc.NNParameters;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.struct.NAHybridStructure;
import org.moltools.lib.struct.UnsupportedHybridStructureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNMeltingPointCalculator
extends AbstractParameterHolder
implements MeltingPointCalculator {
    protected static final float dSSymmetry = -1.4f;
    protected NNParameters params;
    public boolean verbose = false;
    private float sodiumConc = 0.05f;
    private float oligoConc = 1.0f;
    private double logOligo;
    private double RlogC;
    public static final Map<String, String> defaultParameters = new HashMap<String, String>();

    public NNMeltingPointCalculator(NNParameters params) {
        this.setParameters(this.getDefaultParameters());
        this.params = params;
    }

    public NNMeltingPointCalculator() throws IOException {
        this.setParameters(this.getDefaultParameters());
        this.params = new AllawiNNParameters();
    }

    @Override
    public Map<String, String> getDefaultParameters() {
        return defaultParameters;
    }

    protected void readParameters() {
        this.sodiumConc = Float.parseFloat((String)this.parameters.get("SODIUM_CONCENTRATION"));
        this.oligoConc = Float.parseFloat((String)this.parameters.get("PROBE_CONCENTRATION"));
        this.logOligo = Math.log(this.oligoConc / 4.0f) - Math.log(1.0E9);
        this.RlogC = 1.9891173839569092 * this.logOligo;
    }

    @Override
    public void setParameters(Map<String, String> m) {
        super.setParameters(m);
        this.readParameters();
    }

    @Override
    public void addParameters(Map<String, String> m) {
        super.addParameters(m);
        this.readParameters();
    }

    @Override
    public float getMeltingPoint(NucleotideSequence seq) {
        byte[] bytes = NucleotideSequenceHandler.getSequenceByteArray((NucleotideSequence)seq);
        byte atClose = this.countATClosingPairs(bytes);
        byte gcClose = (byte)(2 - atClose);
        float dH_nuc = this.params.getInitH() + (float)atClose * this.params.getInitHAT() + (float)gcClose * this.params.getInitHGC();
        float dS_nuc = this.params.getInitS() + (float)atClose * this.params.getInitSAT() + (float)gcClose * this.params.getInitSGC();
        float dH_dup = 0.0f;
        float dS_dup = 0.0f;
        for (int i = 1; i < bytes.length; ++i) {
            byte x1 = bytes[i - 1];
            byte x2 = bytes[i];
            byte y1 = (byte)(3 - x1);
            byte y2 = (byte)(3 - x2);
            float ddH = this.params.getH(x1, x2, y1, y2);
            float ddS = this.params.getS(x1, x2, y1, y2);
            dH_dup += ddH;
            dS_dup += ddS;
        }
        double dH = dH_dup + dH_nuc;
        double dS = dS_dup + dS_nuc + NNMeltingPointCalculator.getSaltdS(this.sodiumConc, bytes.length);
        float tm = (float)(dH / (dS + this.RlogC));
        return tm - 273.15f;
    }

    @Override
    public float getMeltingPoint(NucleotideSequence sequence1, NucleotideSequence sequence2, NAHybridStructure str) throws UnsupportedHybridStructureException {
        byte type2;
        if (this.oligoConc <= 0.0f) {
            throw new IllegalArgumentException("Illegal nucleic acid concentration");
        }
        byte type1 = sequence1.getType();
        if (this.isValid(type1, type2 = sequence2.getType(), str)) {
            byte atClose = this.countATClosingPairs(str);
            int gcClose = 2 - atClose;
            float dH_nuc = this.params.getInitH() + (float)atClose * this.params.getInitHAT() + (float)gcClose * this.params.getInitHGC();
            float dS_nuc = this.params.getInitS() + (float)atClose * this.params.getInitSAT() + (float)gcClose * this.params.getInitSGC();
            float C = this.oligoConc;
            float dH_dup = 0.0f;
            float dS_dup = 0.0f;
            String str1 = str.getFirstString();
            String str2 = str.getSecondString();
            int s1 = str.getFirstStart();
            int s2 = str.getSecondStart();
            int e1 = str.getFirstEnd();
            int e2 = str.getSecondEnd();
            boolean doEnds = false;
            if (doEnds) {
                if (s1 == 1 && e2 == sequence2.length()) {
                    str1 = "$" + str1;
                    str2 = str2 + "$";
                } else if (s1 == 1) {
                    str1 = "$" + str1;
                    str2 = str2 + sequence2.seqString().charAt(e2);
                } else if (e2 == sequence2.length()) {
                    str1 = sequence1.seqString().charAt(s1 - 2) + str1;
                    str2 = str2 + "$";
                }
                if (s2 == 1 && e1 == sequence1.length()) {
                    str2 = "$" + str2;
                    str1 = str1 + "$";
                } else if (s2 == 1) {
                    str2 = "$" + str2;
                    str1 = str1 + sequence1.seqString().charAt(e1);
                } else if (e1 == sequence1.length()) {
                    str2 = sequence2.seqString().charAt(s2 - 2) + str2;
                    str1 = str1 + "$";
                }
            }
            for (int i = 1; i < str1.length(); ++i) {
                char x1 = str1.charAt(i - 1);
                char x2 = str1.charAt(i);
                char y1 = str2.charAt(str2.length() - i);
                char y2 = str2.charAt(str2.length() - i - 1);
                String nn = String.valueOf(x1) + String.valueOf(x2) + "/" + String.valueOf(y1) + String.valueOf(y2);
                float ddH = this.params.getH(nn);
                float ddS = this.params.getS(nn);
                if (ddH == Float.MAX_VALUE || ddS == Float.MAX_VALUE) {
                    throw new UnsupportedHybridStructureException("Unsupported NN pair: " + nn);
                }
                dH_dup += ddH;
                dS_dup += ddS;
            }
            double dH = dH_dup + dH_nuc;
            double dS = dS_dup + dS_nuc + NNMeltingPointCalculator.getSaltdS(this.sodiumConc, str.getFirstString().length());
            float Tm = (float)(dH / (dS + this.RlogC));
            if (this.verbose) {
                System.out.println(sequence1.seqString() + "\t" + C + "\t" + this.sodiumConc + "\t" + dH + "\t" + dS + "\t" + (Tm - 273.15f));
            }
            return Tm - 273.15f;
        }
        throw new UnsupportedHybridStructureException("Hybrid structure not supported");
    }

    protected static float getSaltdS(float Naconc, int length) {
        float factor = 0.368f;
        return factor * (float)(length - 1) * (float)Math.log(Naconc);
    }

    boolean isValid(byte type1, byte type2, NAHybridStructure str) {
        if (str.getFirstString().length() < 2) {
            return false;
        }
        if (NucleotideSequenceHandler.countPolys((String)str.getFirstString(), (byte)type1) > 0) {
            return false;
        }
        if (NucleotideSequenceHandler.countPolys((String)str.getSecondString(), (byte)type2) > 0) {
            return false;
        }
        try {
            String revComp = NucleotideSequenceHandler.getRevComp((String)str.getSecondString(), (byte)type2, (byte)type1);
            return str.getFirstString().equals(revComp);
        }
        catch (IllegalArgumentException iax) {
            return false;
        }
    }

    protected byte countATClosingPairs(NAHybridStructure struct) {
        byte AT = 0;
        if (struct.getFirstString().startsWith("A")) {
            AT = (byte)(AT + 1);
        }
        if (struct.getFirstString().startsWith("T")) {
            AT = (byte)(AT + 1);
        }
        if (struct.getSecondString().startsWith("A")) {
            AT = (byte)(AT + 1);
        }
        if (struct.getSecondString().startsWith("T")) {
            AT = (byte)(AT + 1);
        }
        return AT;
    }

    protected byte countATClosingPairs(byte[] bytes) {
        byte AT = 0;
        byte s5 = bytes[0];
        byte s3 = bytes[bytes.length - 1];
        if (s5 == 0 || s5 == 3) {
            AT = (byte)(AT + 1);
        }
        if (s3 == 0 || s3 == 3) {
            AT = (byte)(AT + 1);
        }
        return AT;
    }

    static {
        defaultParameters.put("SODIUM_CONCENTRATION", "0.05");
        defaultParameters.put("PROBE_CONCENTRATION", "1");
    }
}

