/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.data.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.moltools.design.data.Group;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.AbstractIdentifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroup<T>
extends AbstractIdentifiable
implements Group<T> {
    protected Collection<T> items;
    private String type;

    public SimpleGroup(String type, String id) {
        super(id);
        this.type = type;
        this.items = new LinkedHashSet<T>();
    }

    @Override
    public String getGroupType() {
        return this.type;
    }

    @Override
    public void addMember(T t) {
        this.items.add(t);
        DesignUtils.addGroup((PropertyAcceptor)t, this);
    }

    @Override
    public void removeMember(T t) {
        this.items.remove(t);
        DesignUtils.removeGroup((PropertyAcceptor)t, this);
    }

    @Override
    public Collection<T> getMembers() {
        return Collections.unmodifiableCollection(this.items);
    }

    @Override
    public boolean isMember(T ph) {
        Group<?> g = DesignUtils.getGroupWithType((PropertyHolder)ph, this.getID());
        if (g != null) {
            return g.equals(this);
        }
        return false;
    }

    public boolean equals(Object obj) {
        Group g;
        if (obj instanceof Group && !(g = (Group)obj).getGroupType().equals(this.getGroupType())) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "(" + this.type + ", " + this.getID() + ")";
    }
}

