/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.utils;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.design.data.Group;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.properties.PropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignUtils {
    public static final String KEY_GROUP = "group";

    public static String getTargetID(PropertyHolder t) {
        PropertySet ps = t.getPropertySet();
        return (String)ps.getSinglePropertyValue("moltools.targetID");
    }

    public static void addGroup(PropertyAcceptor pa, Group<?> g) {
        pa.getMutablePropertySet().addProperty(new SimpleProperty(KEY_GROUP, g, true));
    }

    public static void removeGroup(PropertyAcceptor pa, Group<?> g) {
        pa.getMutablePropertySet().removeProperty(new SimpleProperty(KEY_GROUP, g, true));
    }

    public static Group<?> getGroupWithType(PropertyHolder ph, final String groupType) {
        List<?> c = ph.getPropertySet().getMultiPropertyValues(KEY_GROUP);
        return (Group)CollectionUtils.find(c, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((Group)o).getGroupType().equals(groupType);
            }
        });
    }
}

