/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.utils;

import java.util.Random;
import org.moltools.lib.seq.alphabet.Alphabet;
import org.moltools.lib.seq.alphabet.Symbol;

public class RandomSequenceGenerator {
    Random r = new Random(System.currentTimeMillis());
    Alphabet alphabet;
    int[] weights;
    Symbol[] symbols;

    public RandomSequenceGenerator(Alphabet alphabet, int[] weights) {
        this.alphabet = alphabet;
        this.weights = weights;
        this.setupSymbolArray();
    }

    public RandomSequenceGenerator(Alphabet alphabet) {
        this.alphabet = alphabet;
        this.weights = new int[alphabet.getSymbols().length];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 1;
        }
        this.setupSymbolArray();
    }

    public String[] generateRandomSequenceStrings(int number, int length) {
        String[] sequences = new String[number];
        for (int i = 0; i < sequences.length; ++i) {
            sequences[i] = this.generateRandomSequenceString(length);
        }
        return sequences;
    }

    void setupSymbolArray() {
        int totalWeight = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            totalWeight += this.weights[i];
        }
        this.symbols = new Symbol[totalWeight];
        int pos = 0;
        for (int s = 0; s < this.weights.length; ++s) {
            for (int i = 0; i < this.weights[s]; ++i) {
                this.symbols[pos++] = this.alphabet.getSymbols()[s];
            }
        }
    }

    public String generateRandomSequenceString(int length) {
        String sequence = "";
        for (int i = 0; i < length; ++i) {
            sequence = sequence + this.symbols[this.r.nextInt(this.symbols.length)].getChar();
        }
        return sequence;
    }

    public String perturbSequenceString(String orig, double chance) {
        StringBuffer sequence = new StringBuffer();
        for (int i = 0; i < orig.length(); ++i) {
            if (this.r.nextDouble() < chance) {
                sequence.append(this.symbols[this.r.nextInt(this.symbols.length)].getChar());
                continue;
            }
            sequence.append(orig.charAt(i));
        }
        return sequence.toString();
    }
}

