/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.db.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.MultiValueMap;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.Identifiable;
import org.moltools.lib.seq.Polar;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SubSequenceDescriptor;
import org.moltools.lib.seq.db.SubSequenceStringResolver;
import org.moltools.lib.seq.impl.SimpleNucleotideSubSequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSubSequenceDescriptor;
import org.moltools.lib.seq.utils.AdjacentRegionPredicate;
import org.moltools.lib.seq.utils.IncludesRegionPredicate;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.seq.utils.OverlapsRegionPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentNucleotideSubSequenceStringResolver
implements SubSequenceStringResolver {
    MultiValueMap regionMap = new MultiValueMap();

    public FragmentNucleotideSubSequenceStringResolver(Collection<? extends PolarSubSequenceDescriptor> subsequenceDescriptors, Transformer sequenceExtractor, byte type) {
        Iterator<? extends PolarSubSequenceDescriptor> i = subsequenceDescriptors.iterator();
        while (i.hasNext()) {
            this.addSubSequence(i.next(), sequenceExtractor, type);
        }
    }

    public void addSubSequence(PolarSubSequenceDescriptor s, Transformer sequenceExtractor, byte type) {
        String inputSeqString = (String)sequenceExtractor.transform((Object)s);
        SimpleNucleotideSubSequence newFrag = new SimpleNucleotideSubSequence(NucleotideSequenceHandler.makeSubSequenceID(s), inputSeqString, type, s);
        HashSet subseqs = this.regionMap.getCollection((Object)s.getParentID());
        if (subseqs == null) {
            subseqs = new HashSet();
        }
        ArrayList<SimpleNucleotideSubSequence> overlappers = new ArrayList<SimpleNucleotideSubSequence>(CollectionUtils.select(subseqs, (Predicate)new OverlapsRegionPredicate(s)));
        overlappers.addAll(CollectionUtils.select(subseqs, (Predicate)new AdjacentRegionPredicate(s)));
        Iterator i = overlappers.iterator();
        while (i.hasNext()) {
            this.regionMap.remove((Object)s.getParentID(), i.next());
        }
        if (overlappers.isEmpty()) {
            this.regionMap.put((Object)s.getParentID(), (Object)newFrag);
        } else {
            overlappers.add(newFrag);
            LinkedList<Integer> starts = new LinkedList<Integer>();
            LinkedList<Integer> ends = new LinkedList<Integer>();
            for (SubSequenceDescriptor subSequenceDescriptor : overlappers) {
                starts.add(subSequenceDescriptor.getStart());
                ends.add(subSequenceDescriptor.getEnd());
            }
            Collections.sort(starts);
            Collections.sort(ends);
            int start = (Integer)starts.getFirst();
            int n = (Integer)ends.getLast();
            char[] seqArray = new char[n - start + 1];
            for (SimpleNucleotideSubSequence subseq : overlappers) {
                int offset = subseq.getStart() - start;
                byte polarity = subseq.getPolarity();
                String subString = polarity == 1 ? subseq.seqString() : NucleotideSequenceHandler.getRevComp(subseq);
                for (int pos = 0; pos < subString.length(); ++pos) {
                    int arrayPos = pos + offset;
                    char newSymbol = subString.charAt(pos);
                    char oldSymbol = seqArray[arrayPos];
                    if (oldSymbol != '\u0000' && newSymbol != oldSymbol) {
                        throw new IllegalArgumentException("Sequences do not match:\n" + subseq.getParentID() + " " + (subseq.getStart() + pos) + ", was " + oldSymbol + ", got " + newSymbol);
                    }
                    seqArray[arrayPos] = newSymbol;
                }
            }
            String seqString = new String(seqArray);
            SimpleNucleotideSubSequenceDescriptor pssd = new SimpleNucleotideSubSequenceDescriptor(s.getParentID(), start, n, 1);
            SimpleNucleotideSubSequence composedFrag = new SimpleNucleotideSubSequence(NucleotideSequenceHandler.makeSubSequenceID(pssd), seqString, type, pssd);
            this.regionMap.put((Object)s.getParentID(), (Object)composedFrag);
        }
        try {
            String retSeqString = this.getSequenceString(s);
            if (!retSeqString.equals(inputSeqString)) {
                throw new RuntimeException("Error: wrong sequence returned for " + NucleotideSequenceHandler.makeSubSequenceID(s) + ", expected:\n" + inputSeqString + "\ngot:\n" + retSeqString);
            }
        }
        catch (IDNotFoundException e) {
            throw new RuntimeException("Error: No sequence returned");
        }
    }

    @Override
    public String getSequenceString(SubSequenceDescriptor subseq) throws IDNotFoundException {
        if (!(subseq instanceof Polar)) {
            throw new UnsupportedOperationException("Resolver only supports polar subsequences");
        }
        byte queryPolarity = ((Polar)((Object)subseq)).getPolarity();
        String parentID = subseq.getParentID();
        Collection subseqs = this.regionMap.getCollection((Object)parentID);
        if (subseqs == null) {
            throw new IDNotFoundException("Could not find ID '" + parentID + "'");
        }
        if (subseqs.isEmpty()) {
            throw new IDNotFoundException("No entries for ID: " + parentID);
        }
        SimpleNucleotideSubSequence s = (SimpleNucleotideSubSequence)CollectionUtils.find((Collection)subseqs, (Predicate)new IncludesRegionPredicate(subseq));
        if (s == null) {
            throw new IDNotFoundException("Could not find subsequence for " + parentID + ":" + subseq.getStart() + "-" + subseq.getEnd());
        }
        String seq = s.subsequence(subseq.getStart() - s.getStart() + 1, subseq.getEnd() - s.getStart() + 1);
        return queryPolarity == s.getPolarity() ? seq : NucleotideSequenceHandler.getRevComp(seq, s.getType(), s.getType());
    }

    public Collection<Sequence> getSequenceColection() {
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        for (Object key : this.regionMap.keySet()) {
            Collection subseqs = this.regionMap.getCollection(key);
            seqs.addAll(subseqs);
        }
        Collections.sort(seqs, new Comparator<Identifiable>(){

            @Override
            public int compare(Identifiable o1, Identifiable o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        return seqs;
    }
}

