/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.db.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections.Transformer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.SubSequenceDescriptor;
import org.moltools.lib.seq.db.SequenceDB;
import org.moltools.lib.seq.db.SubSequenceResolver;
import org.moltools.lib.seq.db.SubSequenceStringResolver;
import org.moltools.lib.seq.impl.NamedDNASequenceBuilder;
import org.moltools.lib.seq.impl.NamedNucleotideSequence;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.io.impl.GenBankInputFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenBankSequenceDB<T extends NucleotideSequence>
implements SequenceDB<NucleotideSequence>,
SubSequenceResolver,
SubSequenceStringResolver {
    static ResourceBundle serverConfig = ResourceBundle.getBundle("org.moltools.lib.seq.db.impl.genbankSequenceDB");
    private static String url = serverConfig.getString("genbank.serverURL");
    private static String serverPath = serverConfig.getString("genbank.serverPath");
    public static final String DB_NUCLEOTIDE = "nucleotide";
    public static final String FORMAT_GENBANK = "gb";
    public static final String FORMAT_GENBANK_FULL = "gbwithparts";
    protected SequenceDataReader formatter;
    protected SequenceBuilder<T> builder;
    protected Transformer converter = null;
    protected String formatName = "gbwithparts";
    protected String dbName = "nucleotide";
    protected HttpClient client = null;
    protected static final Log log = LogFactory.getLog(GenBankSequenceDB.class);

    public static GenBankSequenceDB<NamedNucleotideSequence> getDefault() {
        return new GenBankSequenceDB<NamedNucleotideSequence>(new NamedDNASequenceBuilder(), new GenBankInputFormatter());
    }

    public GenBankSequenceDB(SequenceBuilder<T> builder, SequenceDataReader formatter) {
        this.builder = builder;
        this.formatter = formatter;
    }

    protected void initClient() {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        try {
            int timeout = Integer.parseInt(serverConfig.getString("genbank.timeout"));
            this.client.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public T getSequenceByID(String id) throws IDNotFoundException {
        Map<String, String> seqDataMap;
        this.initClient();
        PostMethod method = new PostMethod(url);
        method.getParams().setCookiePolicy("ignoreCookies");
        method.setPath(serverPath);
        method.addParameter("db", this.dbName);
        method.addParameter("id", id);
        method.addParameter("tool", "moltools");
        method.addParameter("strand", "1");
        method.addParameter("retmode", "text");
        method.addParameter("rettype", this.formatName);
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new RuntimeException("Http request failed: " + statusCode);
            }
            InputStream in = method.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            seqDataMap = this.formatter.readNextFormattedSequence(br);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        catch (SequenceFormatException sfx) {
            throw new RuntimeException(sfx);
        }
        finally {
            method.releaseConnection();
        }
        if (seqDataMap == null) {
            throw new IDNotFoundException("Could not find ID in GenBank: " + id);
        }
        NucleotideSequence sequence = (NucleotideSequence)this.builder.buildObject(seqDataMap);
        return (T)sequence;
    }

    @Override
    public Sequence getSequence(SubSequenceDescriptor subseq) throws IDNotFoundException {
        this.initClient();
        if (subseq instanceof PolarSubSequenceDescriptor) {
            PolarSubSequenceDescriptor nsub = (PolarSubSequenceDescriptor)subseq;
            PostMethod method = new PostMethod(url);
            method.getParams().setCookiePolicy("ignoreCookies");
            method.setPath(serverPath);
            method.addParameter("db", this.dbName);
            method.addParameter("id", subseq.getParentID());
            method.addParameter("tool", "moltools");
            method.addParameter("strand", nsub.getPolarity() == 1 ? "1" : "2");
            method.addParameter("seq_start", String.valueOf(nsub.getStart()));
            method.addParameter("seq_stop", String.valueOf(nsub.getEnd()));
            method.addParameter("retmode", "text");
            method.addParameter("rettype", this.formatName);
            Map<String, String> seqDataMap = null;
            int tries = 0;
            while (seqDataMap == null && tries++ < 3) {
                try {
                    int statusCode = this.client.executeMethod((HttpMethod)method);
                    if (statusCode == 200) {
                        InputStream in = method.getResponseBodyAsStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        seqDataMap = this.formatter.readNextFormattedSequence(br);
                        continue;
                    }
                    System.err.println("Http request failed: " + statusCode);
                    System.err.println(method.getResponseBodyAsString());
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
                catch (SequenceFormatException sfx) {
                    throw new RuntimeException(sfx);
                }
                finally {
                    method.releaseConnection();
                }
            }
            if (seqDataMap == null) {
                throw new IDNotFoundException("Could not find ID in GenBank: " + subseq.getParentID());
            }
            Sequence sequence = (Sequence)this.builder.buildObject(seqDataMap);
            return sequence;
        }
        throw new UnsupportedOperationException("GenBankSequenceDB can only resolve nucleotide sequences");
    }

    @Override
    public String getSequenceString(SubSequenceDescriptor subseq) throws IDNotFoundException {
        log.debug((Object)(subseq.getParentID() + ":" + subseq.getStart() + "-" + subseq.getEnd()));
        return this.getSequence(subseq).seqString();
    }
}

