/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.io.impl;

import java.io.PrintWriter;
import java.util.Map;
import org.moltools.lib.Named;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.io.SequenceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlastDBFastaOutputFormatter<T extends Sequence>
implements SequenceWriter<T> {
    int width = 60;

    @Override
    public void writeSequence(PrintWriter ps, T s) {
        StringBuffer defline = new StringBuffer(">");
        defline.append(s.getID());
        if (s instanceof Named) {
            defline.append(" " + ((Named)s).getName());
        }
        ps.println(defline);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < defline.length(); ++i) {
            char c = defline.charAt(i);
            char code = defline.charAt(i);
            if (c == '\'') {
                bf.append("[prime]");
                continue;
            }
            if (code > '\u007f') {
                bf.append("[?]");
                continue;
            }
            bf.append(c);
        }
        String sequence = s.seqString();
        ps.println(bf);
        int length = sequence.length();
        for (int i = 0; i < length; i += this.width) {
            ps.println(sequence.substring(i, Math.min(i + this.width, length)));
        }
    }

    public void writeDataMap(PrintWriter ps, Map<String, String> dataMap) {
        int i;
        String id = dataMap.get("ID");
        String name = dataMap.get("sequence.name");
        String seq = dataMap.get("sequence.seqstring");
        StringBuffer defline = new StringBuffer(">");
        defline.append(id);
        if (name != null) {
            defline.append(" " + name);
        }
        StringBuffer bf = new StringBuffer();
        for (i = 0; i < defline.length(); ++i) {
            char c = defline.charAt(i);
            char code = defline.charAt(i);
            if (c == '\'') {
                bf.append("[prime]");
                continue;
            }
            if (code > '\u007f') {
                bf.append("[?]");
                continue;
            }
            bf.append(c);
        }
        ps.println(bf);
        int length = seq.length();
        for (i = 0; i < length; i += this.width) {
            ps.println(seq.substring(i, Math.min(i + this.width, length)));
        }
    }
}

