/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.calculators;

import org.moltools.apps.probemaker.calculators.SWStructureCalculator;
import org.moltools.apps.probemaker.calculators.StabilityScoreCalculator;
import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.struct.DefaultNASecStructure;
import org.moltools.lib.struct.NASecStructure;

public class HighestStabilityStructureCalculator
extends SWStructureCalculator {
    protected StabilityScoreCalculator ssc;

    public HighestStabilityStructureCalculator(StabilityScoreCalculator ssc) {
        this.ssc = ssc;
    }

    protected Alignment doStrongestIntramolecularLocalAlignment(String seq, byte type) {
        this.minLoopLength = MIN_LOOP_LENGTHS[type];
        this.lac.doAlignment(seq, this.reverse(seq));
        Alignment la = this.lac.getNextAlignment();
        int length = seq.length();
        if (la == null) {
            return null;
        }
        if ((la = new SimpleAlignment(la.getFirstStart(), la.getFirstEnd(), la.getFirstString(), length - la.getSecondEnd() + 1, length - la.getSecondStart() + 1, la.getSecondString())).getFirstStart() > la.getSecondStart()) {
            la = new SimpleAlignment(la.getSecondStart(), la.getSecondEnd(), la.getSecondString(), la.getFirstStart(), la.getFirstEnd(), la.getFirstString());
        }
        boolean overlap = this.isOverlap(la, seq.length());
        while (overlap) {
            la = this.getNextIntramolecularAlignment(length);
            if (la == null) {
                return null;
            }
            overlap = this.isOverlap(la, seq.length());
        }
        return la;
    }

    protected Alignment getNextIntramolecularAlignment(int length) {
        Alignment la = null;
        boolean overlap = true;
        while (overlap) {
            la = this.lac.getNextAlignment();
            if (la == null) {
                return null;
            }
            if (la.getFirstStart() > la.getSecondStart()) {
                la = new SimpleAlignment(la.getSecondStart(), la.getSecondEnd(), la.getSecondString(), la.getFirstStart(), la.getFirstEnd(), la.getFirstString());
            }
            overlap = this.isOverlap(la, length);
        }
        return la;
    }

    public NASecStructure calculateStructure(NucleotideSequence seq, boolean doStability) {
        Alignment la = this.doStrongestIntramolecularLocalAlignment(seq.seqString(), seq.getType());
        DefaultNASecStructure s = null;
        double maxScore = 0.0;
        for (int i = 0; i < 25; ++i) {
            if (la == null) {
                return s;
            }
            DefaultNASecStructure temp = new DefaultNASecStructure(la, seq.length());
            double score = 0.0;
            if (temp.getFirstString() != null && temp.getSecondString() != null) {
                score = this.ssc.getStabilityScore(seq, (NASecStructure)temp);
            }
            if (i == 0) {
                s = temp;
            } else if (score > maxScore) {
                s = temp;
                maxScore = score;
            }
            la = this.getNextIntramolecularAlignment(seq.length());
        }
        return s;
    }
}

