/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import java.io.File;
import java.util.Date;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DoubleDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.data.ListSelectionDescriptor;
import net.sf.apptools.data.OptionDescriptor;
import net.sf.apptools.data.PlugInClassListSelectionDescriptor;
import net.sf.apptools.data.PlugInListSelectionDescriptor;
import net.sf.apptools.data.TextDataDescriptor;
import net.sf.apptools.ui.swing.data.BooleanDataEditor;
import net.sf.apptools.ui.swing.data.DataEditor;
import net.sf.apptools.ui.swing.data.DataEditorFactory;
import net.sf.apptools.ui.swing.data.DateDataEditor;
import net.sf.apptools.ui.swing.data.DoubleDataEditor;
import net.sf.apptools.ui.swing.data.FileDataEditor;
import net.sf.apptools.ui.swing.data.IntegerDataEditor;
import net.sf.apptools.ui.swing.data.ListSelectionEditor;
import net.sf.apptools.ui.swing.data.OptionEditor;
import net.sf.apptools.ui.swing.data.PlugInListSelectionEditor;
import net.sf.apptools.ui.swing.data.SmallOptionEditor;
import net.sf.apptools.ui.swing.data.StringDataEditor;
import net.sf.apptools.ui.swing.data.TextDataEditor;
import net.sf.apptools.ui.swing.plugin.PlugInRenderer;

public class DefaultDataEditorFactory
extends DataEditorFactory {
    public boolean supportsDescriptorInternal(DataDescriptor desc) {
        Class valueClass = desc.getDataType();
        if (valueClass == Integer.class) {
            return true;
        }
        if (valueClass == Double.class) {
            return true;
        }
        if (valueClass == Boolean.class) {
            return true;
        }
        if (valueClass == String.class) {
            return true;
        }
        if (valueClass == File.class) {
            return true;
        }
        if (valueClass == Date.class) {
            return true;
        }
        if (desc instanceof PlugInClassListSelectionDescriptor) {
            return true;
        }
        if (desc instanceof ListSelectionDescriptor) {
            return true;
        }
        return desc instanceof OptionDescriptor;
    }

    public DataEditor createDataEditorInternal(DataDescriptor descriptor, boolean makeSmall) {
        DataEditor dataComponent = null;
        Class valueClass = descriptor.getDataType();
        String name = descriptor.getName();
        String desc = descriptor.getDescription();
        if (descriptor instanceof OptionDescriptor) {
            OptionDescriptor param = (OptionDescriptor)descriptor;
            dataComponent = makeSmall ? new SmallOptionEditor(param) : new OptionEditor(param);
        } else if (descriptor instanceof PlugInClassListSelectionDescriptor) {
            PlugInClassListSelectionDescriptor data = (PlugInClassListSelectionDescriptor)descriptor;
            dataComponent = new PlugInListSelectionEditor(data);
        } else if (descriptor instanceof PlugInListSelectionDescriptor) {
            ListSelectionDescriptor data = (ListSelectionDescriptor)descriptor;
            dataComponent = makeSmall ? new SmallOptionEditor(data, new PlugInRenderer(null)) : new ListSelectionEditor(data, new PlugInRenderer(null));
        } else if (descriptor instanceof ListSelectionDescriptor) {
            ListSelectionDescriptor data = (ListSelectionDescriptor)descriptor;
            dataComponent = makeSmall ? new SmallOptionEditor(data, null) : new ListSelectionEditor(data, null);
        } else if (descriptor instanceof TextDataDescriptor) {
            dataComponent = new TextDataEditor(name, desc);
        } else if (descriptor instanceof IntegerDescriptor) {
            dataComponent = new IntegerDataEditor(name, desc);
        } else if (valueClass == Integer.class) {
            dataComponent = new IntegerDataEditor(name, desc);
        } else if (descriptor instanceof DoubleDescriptor) {
            dataComponent = new DoubleDataEditor(name, desc);
        } else if (valueClass == Double.class) {
            dataComponent = new DoubleDataEditor(name, desc);
        } else if (valueClass == Boolean.class) {
            dataComponent = new BooleanDataEditor(name, desc);
        } else if (valueClass == File.class) {
            dataComponent = new FileDataEditor(name, desc);
        } else if (valueClass == Date.class) {
            dataComponent = new DateDataEditor(name, desc);
        } else if (valueClass == String.class) {
            dataComponent = new StringDataEditor(name, desc);
        } else {
            throw new UnsupportedOperationException("Data type not supported: " + descriptor.getClass());
        }
        return dataComponent;
    }
}

