/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.io.Reader;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.AbstractTask;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.io.TargetInputFormat;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.utils.SequenceIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetIOTask
extends AbstractTask {
    protected Project project;
    TargetInputFormat<?> format;
    Reader[] ins;

    public TargetIOTask(Project p, ErrorHandler ecb, Reader[] ins, TargetInputFormat<?> format) {
        super(CoreMessages.getString("TargetIOTask.TITLE_READING_TARGETS"), 0, -1, 1, ecb);
        this.project = p;
        this.format = format;
        this.ins = ins;
    }

    public void run() {
        this.setStatus(CoreMessages.getString("TargetIOTask.MESSAGE_READING_TARGETS"), 0);
        try {
            for (int i = 0; i < this.ins.length; ++i) {
                if (this.isAborted()) {
                    return;
                }
                Reader in = this.ins[i];
                if (in == null) continue;
                DefiniteSequenceDB newTargets = SequenceIO.readSequenceDB((Reader)in, this.format);
                this.project.getTargets().addSequences(newTargets);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        this.setCompleted();
    }
}

