/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Transformer;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.io.SequenceDataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputIterator
implements Iterator<Sequence> {
    protected Sequence buffer = null;
    protected BufferedReader bufferedReader;
    protected SequenceDataReader formatter;
    protected SequenceBuilder<? extends Sequence> seqBuilder;
    protected Transformer sequenceStringConverter;

    public SequenceInputIterator(Reader reader, SequenceDataReader formatter, Transformer sequenceStringConverter, SequenceBuilder<? extends Sequence> seqBuilder) {
        this.formatter = formatter;
        this.seqBuilder = seqBuilder;
        this.sequenceStringConverter = sequenceStringConverter;
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            this.buffer = this.getNextSequence();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SequenceFormatException e) {
            throw new RuntimeException(e);
        }
    }

    protected Sequence getNextSequence() throws IOException, SequenceFormatException {
        Map<String, String> seqData = this.formatter.readNextFormattedSequence(this.bufferedReader);
        if (seqData == null) {
            return null;
        }
        return (Sequence)this.seqBuilder.buildObject(seqData);
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null;
    }

    @Override
    public Sequence next() {
        if (this.buffer == null) {
            throw new NoSuchElementException();
        }
        Sequence o = this.buffer;
        try {
            this.buffer = this.getNextSequence();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SequenceFormatException e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator is read-only");
    }
}

