/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.genefront.piecemaker.PieceMakerPlugIn;
import net.genefront.piecemaker.io.TargetTextTableFormatter;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DefaultDataHolder;
import net.sf.apptools.data.FileDataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.task.AbstractTask;
import net.sf.apptools.task.Task;
import net.sf.apptools.ui.UIActivePlugIn;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.utils.AppUtils;
import org.apache.commons.io.IOUtils;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.io.SequenceDataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisperseGUIPlugin
extends JPanel
implements UIActivePlugIn {
    UserAction run;
    UserAction saveOutput;
    UserAction displayFragments;
    UserAction displaySelection;
    UserAction about;
    UserAction[] helpActionSet;
    UserAction[] jobActionSet;
    Platform platform;
    SwingWorkbenchUI workbench;
    FileDataDescriptor inputFileDesc = new FileDataDescriptor("Input file", "The input file of gene names", "INPUT_FILE", true);
    FileDataDescriptor settingsFileDesc = new FileDataDescriptor("Settings file", "The settings file with design parameters", "SETTINGS_FILE", true);
    FileDataDescriptor configFileDesc = new FileDataDescriptor("Config file", "The config file with setup parameters [optional]", "CONFIG_FILE", false);
    IntegerDescriptor startDescriptor = new IntegerDescriptor("Start at stage", "Stage number to start at", "START_STAGE", 1, 10);
    IntegerDescriptor endDescriptor = new IntegerDescriptor("Stop at stage", "Stage number to end at", "STOP_STAGE", 1, 10);
    BooleanDescriptor snpDescriptor = new BooleanDescriptor("Use SNPs", "Whether or not to use SNP data", "USE_SNP");
    DataDescriptor[] jobdescriptors = new DataDescriptor[]{this.inputFileDesc, this.settingsFileDesc, this.configFileDesc, this.startDescriptor, this.endDescriptor, this.snpDescriptor};
    DataHolder dataHolder = new DefaultDataHolder(this.jobdescriptors);
    protected JTextArea outputDisplay;
    protected Writer outputWriter;

    public static String getBriefDescription() {
        return "Disperse GUI";
    }

    public static String getLongDescription() {
        return "A graphical user interface for the Disperse pipeline";
    }

    public DisperseGUIPlugin() {
        this.enableEvents(64L);
    }

    private void jbInit() throws Exception {
        DisperseGUIPlugin contentPane = this;
        contentPane.setLayout(new BorderLayout());
        this.outputDisplay = new JTextArea();
        this.outputDisplay.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.outputDisplay);
        contentPane.add(scrollPane);
    }

    public Icon getIcon() {
        return null;
    }

    public Component createFunctionalityUI() {
        return this;
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SwingWorkbenchUI.class.getName(), "1.0");
        return map;
    }

    public void setup(Platform platform) throws PlugInException {
        this.about = new AbstractUserAction("About Disperse", "Show information about Disperse"){

            public void execute() {
                DisperseGUIPlugin.this.showAboutDialog();
            }
        };
        this.run = new AbstractUserAction("Run pipeline...", "Run the Disperse pipeline"){

            public void execute() {
                DisperseGUIPlugin.this.runPipeline();
            }
        };
        this.saveOutput = new AbstractUserAction("Save output...", "Save latest output to file"){

            public void execute() {
                DisperseGUIPlugin.this.saveOutput();
            }
        };
        this.displayFragments = new AbstractUserAction("Display all fragments", "Display all fragments in PieceMaker"){

            public void execute() {
                DisperseGUIPlugin.this.displayFragments();
            }
        };
        this.displaySelection = new AbstractUserAction("Display fragment subset", "Display selected subset of fragments in PieceMaker"){

            public void execute() {
                DisperseGUIPlugin.this.displaySelection();
            }
        };
        this.helpActionSet = new UserAction[]{this.about};
        this.jobActionSet = new UserAction[]{this.run, this.saveOutput, this.displayFragments, this.displaySelection};
        this.platform = platform;
        this.workbench = (SwingWorkbenchUI)platform.getPlugInInstance(SwingWorkbenchUI.class);
        if (this.workbench == null) {
            throw new PlugInException("The Workbench could not be found");
        }
        try {
            if (!AppUtils.checkJavaVersion((String)"1.5")) {
                this.workbench.sendMessage("Java version 1.5 is required for Disperse. Please update.", "Java version", (byte)0);
            }
            this.jbInit();
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        platform.addActionSet(new ActionSet(this.helpActionSet, "Disperse/Help", (ActivePlugIn)this, 1000));
        platform.addActionSet(new ActionSet(this.jobActionSet, "Disperse/Run", (ActivePlugIn)this, 400));
        this.outputWriter = new Writer(){

            public void write(char[] arg0, int arg1, int arg2) {
                DisperseGUIPlugin.this.outputDisplay.append(new String(arg0, arg1, arg2));
                DisperseGUIPlugin.this.outputDisplay.repaint();
            }

            public void flush() {
            }

            public void close() {
            }
        };
        this.dataHolder.setData(this.snpDescriptor.getKey(), (Object)true);
        this.dataHolder.setData(this.startDescriptor.getKey(), (Object)1);
        this.dataHolder.setData(this.endDescriptor.getKey(), (Object)10);
    }

    public void displayFragments(File targetFile, File fragmentFile) {
        try {
            FileReader tin = new FileReader(targetFile);
            FileReader fin = new FileReader(fragmentFile);
            PieceMakerPlugIn pim = (PieceMakerPlugIn)this.platform.getPlugInInstance(PieceMakerPlugIn.class);
            if (pim == null) {
                this.platform.activatePlugIn(PieceMakerPlugIn.class);
                pim = (PieceMakerPlugIn)this.platform.getPlugInInstance(PieceMakerPlugIn.class);
            }
            pim.loadTargets((Reader)tin, (SequenceDataReader)new TargetTextTableFormatter());
            tin.close();
            pim.loadAcceptedFragments((Reader)fin);
            fin.close();
        }
        catch (IOException iox) {
            this.platform.handleError(iox.getMessage(), (Throwable)iox);
        }
        catch (SequenceFormatException sfx) {
            this.platform.handleError(sfx.getMessage(), (Throwable)sfx);
        }
        catch (Exception ex) {
            this.platform.handleError("Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void displaySelection() {
        try {
            boolean isSNP = (Boolean)this.dataHolder.getData(this.snpDescriptor.getKey());
            File inputFile = (File)this.dataHolder.getData(this.inputFileDesc.getKey());
            if (inputFile == null) {
                this.platform.getUI().sendMessage("No design job available", "Error", (byte)0);
                return;
            }
            File selectionFile = new File(inputFile.getAbsolutePath() + ".selection");
            File targetFile = new File(inputFile.getAbsolutePath() + (isSNP ? ".snp_target" : ".target"));
            if (!targetFile.exists()) {
                this.platform.getUI().sendMessage("Target file does not exist: " + targetFile.getAbsolutePath(), "Error", (byte)0);
                return;
            }
            if (!selectionFile.exists()) {
                this.platform.getUI().sendMessage("Selection file does not exist: " + selectionFile.getAbsolutePath(), "Error", (byte)0);
                return;
            }
            this.displayFragments(targetFile, selectionFile);
        }
        catch (Exception ex) {
            this.platform.handleError("Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void displayFragments() {
        try {
            boolean isSNP = (Boolean)this.dataHolder.getData(this.snpDescriptor.getKey());
            File inputFile = (File)this.dataHolder.getData(this.inputFileDesc.getKey());
            if (inputFile == null) {
                this.platform.getUI().sendMessage("No design job available", "Error", (byte)0);
                return;
            }
            File fragmentFile = new File(inputFile.getAbsolutePath() + ".fragment");
            File targetFile = new File(inputFile.getAbsolutePath() + (isSNP ? ".snp_target" : ".target"));
            if (!targetFile.exists()) {
                this.platform.getUI().sendMessage("Target file does not exist: " + targetFile.getAbsolutePath(), "Error", (byte)0);
                return;
            }
            if (!fragmentFile.exists()) {
                this.platform.getUI().sendMessage("Fragment file does not exist: " + fragmentFile.getAbsolutePath(), "Error", (byte)0);
                return;
            }
            this.displayFragments(targetFile, fragmentFile);
        }
        catch (Exception ex) {
            this.platform.handleError("Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        return true;
    }

    public String getVersion() {
        return "1.0.1";
    }

    public void showAboutDialog() {
        Disperse_AboutBox dlg = new Disperse_AboutBox(GUIUtils.getParentFrame((Component)this));
        GUIUtils.checkSize((JDialog)dlg);
        dlg.setLocation(GUIUtils.suggestLocation((Window)dlg, (Frame)GUIUtils.getParentFrame((Component)this)));
        dlg.setVisible(true);
    }

    public void saveOutput() {
        File f = this.platform.getUI().selectSaveFile(null, new File("disperse_output.txt"), "Select file to save to", "");
        if (f == null) {
            return;
        }
        try {
            FileWriter out = new FileWriter(f);
            IOUtils.write((String)this.outputDisplay.getText(), (Writer)out);
            out.close();
        }
        catch (IOException e) {
            this.platform.handleError("Failed to save output", (Throwable)e);
        }
    }

    public void runPipeline() {
        boolean go = this.platform.getUI().inputData(this.dataHolder, "Job options");
        if (!go) {
            return;
        }
        this.outputDisplay.setText("");
        final PrintWriter out = new PrintWriter(this.outputWriter);
        File inputFile = (File)this.dataHolder.getData(this.inputFileDesc.getKey());
        File settingsFile = (File)this.dataHolder.getData(this.settingsFileDesc.getKey());
        File configFile = (File)this.dataHolder.getData(this.configFileDesc.getKey());
        int start = (Integer)this.dataHolder.getData(this.startDescriptor.getKey());
        int stop = (Integer)this.dataHolder.getData(this.endDescriptor.getKey());
        boolean snp = (Boolean)this.dataHolder.getData(this.snpDescriptor.getKey());
        final ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("perl");
        cmds.add("scripts/disperse.pl");
        cmds.add("-i");
        cmds.add(inputFile.getAbsolutePath());
        cmds.add("-s");
        cmds.add(settingsFile.getAbsolutePath());
        if (configFile != null) {
            cmds.add("-c");
            cmds.add(configFile.getAbsolutePath());
        }
        if (!snp) {
            cmds.add("-nosnp");
        }
        cmds.add("-start");
        cmds.add(String.valueOf(start));
        cmds.add("-stop");
        cmds.add(String.valueOf(stop));
        out.print("Running Disperse with:");
        for (String cmd : cmds) {
            out.print(" " + cmd);
        }
        out.println();
        AbstractTask t = new AbstractTask("Disperse", 0, -1, 0, (ErrorHandler)this.platform){
            Process p;

            public void abort() {
                super.abort();
                if (this.p != null) {
                    this.p.destroy();
                }
            }

            public void run() {
                try {
                    this.p = Runtime.getRuntime().exec(cmds.toArray(new String[cmds.size()]));
                    InputStreamReader in = new InputStreamReader(this.p.getInputStream());
                    InputStreamReader err = new InputStreamReader(this.p.getErrorStream());
                    Consumer inconsumer = new Consumer(in, out);
                    Consumer errconsumer = new Consumer(err, out);
                    inconsumer.start();
                    errconsumer.start();
                    int exitValue = this.p.waitFor();
                    out.flush();
                    if (exitValue != 0) {
                        DisperseGUIPlugin.this.platform.handleError("Disperse returned error code " + exitValue, null);
                        out.println("ERROR Disperse returned error code " + exitValue);
                    }
                    out.close();
                }
                catch (IOException e) {
                    this.handleError(e);
                }
                catch (InterruptedException e) {
                    this.handleError(e);
                }
                this.setCompleted();
            }
        };
        this.platform.runTask((Task)t);
    }

    class Disperse_AboutBox
    extends JDialog
    implements ActionListener {
        JPanel panel1;
        JPanel mainPanel;
        JPanel buttonPanel;
        JPanel textPanel1;
        JPanel textPanel2;
        JPanel textPanel3;
        JPanel textPanel4;
        JButton okButton;
        JButton exitButton;
        JLabel label1;
        JLabel label2;
        JLabel label3;
        JLabel label4;
        JLabel label5;
        JLabel label11;
        String product;
        String version;
        String copyright;
        String comments;
        String web;
        String license;

        public Disperse_AboutBox(Frame parent) {
            super(parent);
            this.panel1 = new JPanel();
            this.mainPanel = new JPanel();
            this.buttonPanel = new JPanel();
            this.textPanel1 = new JPanel();
            this.textPanel2 = new JPanel();
            this.textPanel3 = new JPanel();
            this.textPanel4 = new JPanel();
            this.okButton = new JButton();
            this.exitButton = new JButton();
            this.label1 = new JLabel();
            this.label2 = new JLabel();
            this.label3 = new JLabel();
            this.label4 = new JLabel();
            this.label5 = new JLabel();
            this.label11 = new JLabel();
            this.product = "Disperse";
            this.version = "Version 1.0.1";
            this.copyright = "Copyright (c) 2008";
            this.comments = "Stanford University";
            this.web = "http://www.bioinformatics.org/disperse/";
            this.license = "License: GNU GENERAL PUBLIC LICENSE ";
            this.enableEvents(64L);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        Disperse_AboutBox() {
            this(null);
        }

        private void jbInit() throws Exception {
            this.setTitle("About Disperse");
            this.label1.setText(this.product);
            this.label2.setText(this.version);
            this.label3.setText(this.copyright);
            this.label4.setText(this.comments);
            this.label5.setText(this.web);
            this.label11.setText(this.license);
            JEditorPane licArea = new JEditorPane(new File("gpl-license.txt").toURI().toURL());
            licArea.setEditable(false);
            licArea.setCaretPosition(0);
            JScrollPane sp = new JScrollPane(licArea);
            this.okButton.setText("OK");
            this.okButton.addActionListener(this);
            this.label5.setFont(this.label5.getFont().deriveFont(1));
            this.label1.setFont(this.label5.getFont().deriveFont((float)(this.label1.getFont().getSize() + 8)));
            this.label11.setFont(this.label5.getFont());
            this.textPanel1.setLayout(new GridLayout(4, 1));
            this.textPanel1.add((Component)this.label2, null);
            this.textPanel1.add((Component)this.label3, null);
            this.textPanel1.add((Component)this.label4, null);
            this.textPanel2.setLayout(new GridLayout(4, 1));
            this.textPanel2.add((Component)this.label5, null);
            JPanel epanel = new JPanel(new BorderLayout());
            epanel.add(sp);
            this.mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints con = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0);
            this.mainPanel.add((Component)this.label1, con);
            ++con.gridy;
            con.insets = new Insets(10, 20, 2, 2);
            this.mainPanel.add((Component)this.textPanel1, con);
            ++con.gridy;
            con.insets = new Insets(10, 2, 2, 2);
            this.mainPanel.add((Component)this.textPanel2, con);
            ++con.gridy;
            this.mainPanel.add((Component)this.label11, con);
            ++con.gridy;
            con.weighty = 2.0;
            this.mainPanel.add((Component)epanel, con);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 10));
            this.buttonPanel.setLayout(new FlowLayout(4));
            this.buttonPanel.add(this.okButton);
            this.panel1.setLayout(new BorderLayout());
            this.panel1.add((Component)this.mainPanel, "Center");
            this.panel1.add((Component)this.buttonPanel, "South");
            JPanel cp = (JPanel)this.getContentPane();
            cp.add(this.panel1);
            this.pack();
            this.setSize(500, 600);
        }

        protected void processWindowEvent(WindowEvent e) {
            if (e.getID() == 201) {
                this.cancel();
            }
            super.processWindowEvent(e);
        }

        void cancel() {
            this.dispose();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                this.cancel();
            }
        }
    }

    class Consumer
    extends Thread {
        Reader in;
        PrintWriter out;

        Consumer(Reader in, PrintWriter out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(this.in);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.out.println(line);
                    this.out.flush();
                }
            }
            catch (IOException iox) {
                DisperseGUIPlugin.this.platform.handleError(iox.getMessage(), (Throwable)iox);
            }
        }
    }
}

