/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.genefront.piecemaker.PieceMakerFrame_enzymeTable_keyAdapter;
import net.genefront.piecemaker.PieceMakerFrame_targetTable_keyAdapter;
import net.genefront.piecemaker.PieceMakerPlugIn;
import net.genefront.piecemaker.TargetCutterFrame_acceptedTable1_mouseAdapter;
import net.genefront.piecemaker.TargetCutterFrame_acceptedTable_mouseAdapter;
import net.genefront.piecemaker.TargetCutterFrame_combinationTable_mouseAdapter;
import net.genefront.piecemaker.TargetCutterFrame_fragmentSetTable_mouseAdapter;
import net.genefront.piecemaker.TargetCutterFrame_resultsTable_mouseAdapter;
import net.genefront.piecemaker.TargetCutterFrame_targetTable_mouseAdapter;
import net.genefront.piecemaker.gui.CombinationTableModel;
import net.genefront.piecemaker.gui.CoverageDialog;
import net.genefront.piecemaker.gui.CutFragmentTableModel;
import net.genefront.piecemaker.gui.CutResultsTableModel;
import net.genefront.piecemaker.gui.CutResultsTableSorter;
import net.genefront.piecemaker.gui.FragmentSetDialog;
import net.genefront.piecemaker.gui.PieceMaker_AboutBox;
import net.genefront.piecemaker.gui.RestrictionReactionTableModel;
import net.genefront.piecemaker.gui.TargetTableModel;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.MutableFragmentSet;
import net.genefront.piecemaker.model.PieceMakerProject;
import net.genefront.piecemaker.model.ProjectChangeEvent;
import net.genefront.piecemaker.model.ProjectChangeListener;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.model.impl.PieceMakerDataFactory;
import net.genefront.piecemaker.restriction.RestrictionEnzyme;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.ui.UIActivePlugIn;
import net.sf.apptools.ui.swing.SwingUserAction;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.utils.AppUtils;
import org.moltools.lib.Identifiable;
import org.moltools.lib.seq.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceMakerGUI
extends JPanel
implements TableModelListener,
ProjectChangeListener,
UIActivePlugIn {
    private static final long serialVersionUID = 1L;
    JLabel statusBar = new JLabel();
    JPanel inputControlPanel = new JPanel(new FlowLayout(3));
    JPanel resultsControlPanel = new JPanel(new FlowLayout(3));
    JPanel combinationControlPanel = new JPanel(new FlowLayout(3));
    JLabel successesLabel = new JLabel();
    JTextField successCountField = new JTextField();
    JTabbedPane tabPane = new JTabbedPane();
    JSplitPane targetEnzymeSplitPane = new JSplitPane();
    JPanel targetPanel = new JPanel();
    JScrollPane targetScrollPane = new JScrollPane();
    JTable targetTable = new JTable();
    JPanel enzymePanel = new JPanel();
    JScrollPane enzymeScrollPane = new JScrollPane();
    JTable reactionTable = new JTable();
    JSplitPane resultSplitPane = new JSplitPane();
    JPanel allPanel = new JPanel();
    JScrollPane allResultsScrollPane = new JScrollPane();
    JTable allResultsTable = new JTable();
    JPanel acceptedPanel = new JPanel();
    JScrollPane acceptedResultsScrollPane = new JScrollPane();
    JTable acceptedResultsTable = new JTable();
    JSplitPane combinationSplitPane = new JSplitPane();
    JPanel combinationAcceptedPanel = new JPanel();
    JScrollPane combinationAcceptedScrollPane = new JScrollPane();
    JTable combinationAcceptedTable = new JTable();
    JPanel combinationSelectedPanel = new JPanel();
    JScrollPane combinationSelectedScrollPane = new JScrollPane();
    JTable combinationSelectedTable = new JTable();
    TargetTableModel targetModel;
    RestrictionReactionTableModel reactionModel;
    CutResultsTableModel resultsModel;
    CutResultsTableModel acceptedModel;
    CutResultsTableModel combinationAcceptedModel;
    CombinationTableModel combinationModel;
    UserAction about;
    UserAction[] helpActionSet;
    JLabel targetInfoLabel1 = new JLabel("Double-click to display sequence");
    JLabel targetInfoLabel2 = new JLabel("Press DEL to remove the selected target");
    JLabel reactionInfoLabel1 = new JLabel("Press DEL to remove the selected reaction");
    JLabel resultTableInfoLabel1 = new JLabel("Double-click to display fragment list");
    JLabel resultTableInfoLabel2 = new JLabel("Right-click to change between target and reaction view");
    JLabel resultTableInfoLabel3 = new JLabel("Click headers to sort");
    JLabel acceptedTableInfoLabel1 = new JLabel("Double-click to display fragment list");
    JLabel acceptedTableInfoLabel2 = new JLabel("Right-click to change between target and reaction view");
    JLabel acceptedTableInfoLabel3 = new JLabel("Click headers to sort");
    JLabel combinationAcceptedInfoLabel1 = new JLabel("Double-click on a reaction to add to combination");
    JLabel combinationAcceptedInfoLabel2 = new JLabel("Right-click to display fragment list");
    JLabel combinationSelectedInfoLabel1 = new JLabel("Double-click to display fragment list, right-click to display fragment view");
    JLabel combinationSelectedInfoLabel2 = new JLabel("Click on table header to remove a reaction");
    PieceMakerPlugIn piecemaker;
    Platform platform;
    SwingWorkbenchUI workbench;

    public static String getBriefDescription() {
        return "PieceMaker GUI";
    }

    public static String getLongDescription() {
        return "A graphical user interface for the PieceMaker application";
    }

    public PieceMakerGUI() {
        this.enableEvents(64L);
        this.targetModel = new TargetTableModel();
        this.targetTable.setModel(this.targetModel);
        this.reactionModel = new RestrictionReactionTableModel();
        this.reactionTable.setModel(this.reactionModel);
        this.resultsModel = new CutResultsTableModel();
        CutResultsTableSorter allResultsSorter = new CutResultsTableSorter(this.resultsModel);
        this.allResultsTable.setModel(allResultsSorter);
        allResultsSorter.setTableHeader(this.allResultsTable.getTableHeader());
        this.acceptedModel = new CutResultsTableModel();
        CutResultsTableSorter acceptedResultsSorter = new CutResultsTableSorter(this.acceptedModel);
        this.acceptedResultsTable.setModel(acceptedResultsSorter);
        acceptedResultsSorter.setTableHeader(this.acceptedResultsTable.getTableHeader());
        this.combinationAcceptedModel = new CutResultsTableModel();
        CutResultsTableSorter acceptedSorter1 = new CutResultsTableSorter(this.combinationAcceptedModel);
        this.combinationAcceptedTable.setModel(acceptedSorter1);
        acceptedSorter1.setTableHeader(this.combinationAcceptedTable.getTableHeader());
        this.combinationModel = new CombinationTableModel();
        this.combinationModel.addTableModelListener(this);
        this.combinationSelectedTable.setModel(this.combinationModel);
        this.targetTable.addMouseListener(new TargetCutterFrame_targetTable_mouseAdapter(this));
        this.targetTable.addKeyListener(new PieceMakerFrame_targetTable_keyAdapter(this));
        this.reactionTable.addKeyListener(new PieceMakerFrame_enzymeTable_keyAdapter(this));
        this.allResultsTable.addMouseListener(new TargetCutterFrame_resultsTable_mouseAdapter(this));
        this.acceptedResultsTable.addMouseListener(new TargetCutterFrame_acceptedTable_mouseAdapter(this));
        this.combinationAcceptedTable.addMouseListener(new TargetCutterFrame_acceptedTable1_mouseAdapter(this));
        this.combinationSelectedTable.addMouseListener(new TargetCutterFrame_combinationTable_mouseAdapter(this));
        this.combinationSelectedTable.getTableHeader().addMouseListener(new TargetCutterFrame_combinationTable_mouseAdapter(this));
    }

    private void jbInit() throws Exception {
        PieceMakerGUI contentPane = this;
        contentPane.setLayout(new BorderLayout());
        Border panelBorder = BorderFactory.createBevelBorder(1);
        Border scrollPaneBorder = BorderFactory.createEmptyBorder();
        this.acceptedResultsScrollPane.setPreferredSize(new Dimension(458, 423));
        this.acceptedResultsScrollPane.setRequestFocusEnabled(true);
        this.successesLabel.setText("Successes:");
        this.successCountField.setEnabled(false);
        this.successCountField.setText("");
        this.successCountField.setColumns(5);
        JButton saveReactionsTextButton = new JButton((Action)new SwingUserAction(this.piecemaker.saveReactionsText));
        JButton loadReactionsTextButton = new JButton((Action)new SwingUserAction(this.piecemaker.loadReactionsText));
        JButton saveReactionsXMLButton = new JButton((Action)new SwingUserAction(this.piecemaker.saveReactionsXML));
        JButton loadReactionsXMLButton = new JButton((Action)new SwingUserAction(this.piecemaker.loadReactionsXML));
        JButton saveFragmentsButton = new JButton((Action)new SwingUserAction(this.piecemaker.saveFragments));
        JButton loadFragmentsButton = new JButton((Action)new SwingUserAction(this.piecemaker.loadFragments));
        JButton findSitesButton = new JButton((Action)new SwingUserAction(this.piecemaker.findSites));
        JButton openTargetsButton = new JButton((Action)new SwingUserAction(this.piecemaker.openTargets));
        JButton openEnzymesButton = new JButton((Action)new SwingUserAction(this.piecemaker.openEnzymes));
        JButton cutButton = new JButton((Action)new SwingUserAction(this.piecemaker.cut));
        JButton selectButton = new JButton((Action)new SwingUserAction(this.piecemaker.select));
        JButton mergeEnzymesButton = new JButton((Action)new SwingUserAction(this.piecemaker.mergeEnzymes));
        JButton selectCombinationFragmentsButton = new JButton((Action)new SwingUserAction(this.piecemaker.selectCombinationFragments));
        JButton resetAcceptedButton = new JButton((Action)new SwingUserAction(this.piecemaker.resetAccepted));
        JButton selectSuccessCalculatorButton = new JButton((Action)new SwingUserAction(this.piecemaker.selectCombinationSelector));
        JButton selectCombinationButton = new JButton((Action)new SwingUserAction(this.piecemaker.selectCombination));
        this.targetPanel.setLayout(new BorderLayout());
        this.targetPanel.setBorder(panelBorder);
        this.enzymePanel.setLayout(new BorderLayout());
        this.enzymePanel.setBorder(panelBorder);
        this.inputControlPanel.add(openTargetsButton);
        this.inputControlPanel.add(openEnzymesButton);
        this.inputControlPanel.add(mergeEnzymesButton);
        this.inputControlPanel.add(loadReactionsXMLButton);
        this.inputControlPanel.add(saveReactionsXMLButton);
        this.inputControlPanel.add(loadReactionsTextButton);
        this.inputControlPanel.add(saveReactionsTextButton);
        this.acceptedPanel.setLayout(new BorderLayout());
        this.acceptedPanel.setBorder(panelBorder);
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(panelBorder);
        this.resultsControlPanel.add(cutButton);
        this.resultsControlPanel.add(findSitesButton);
        this.resultsControlPanel.add(selectButton);
        this.resultsControlPanel.add(resetAcceptedButton);
        this.combinationAcceptedPanel.setLayout(new BorderLayout());
        this.combinationAcceptedPanel.setBorder(panelBorder);
        this.combinationSelectedPanel.setLayout(new BorderLayout());
        this.combinationSelectedPanel.setBorder(panelBorder);
        this.combinationControlPanel.add(selectSuccessCalculatorButton);
        this.combinationControlPanel.add(selectCombinationButton);
        this.combinationControlPanel.add(selectCombinationFragmentsButton);
        this.combinationControlPanel.add(saveFragmentsButton);
        this.combinationControlPanel.add(loadFragmentsButton);
        this.combinationControlPanel.add(this.successesLabel);
        this.combinationControlPanel.add(this.successCountField);
        this.targetScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "Targets"));
        this.enzymeScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "Enzymes"));
        this.allResultsScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "All fragments"));
        this.acceptedResultsScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "Accepted fragments"));
        this.combinationAcceptedScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "Accepted fragments"));
        this.combinationSelectedScrollPane.setBorder(new TitledBorder(scrollPaneBorder, "Combinations"));
        JPanel targetEnzymePane = new JPanel(new BorderLayout());
        JPanel resultsPane = new JPanel(new BorderLayout());
        JPanel combinationsPane = new JPanel(new BorderLayout());
        targetEnzymePane.add((Component)this.targetEnzymeSplitPane, "Center");
        resultsPane.add((Component)this.resultSplitPane, "Center");
        combinationsPane.add((Component)this.combinationSplitPane, "Center");
        targetEnzymePane.add((Component)this.inputControlPanel, "First");
        resultsPane.add((Component)this.resultsControlPanel, "First");
        combinationsPane.add((Component)this.combinationControlPanel, "First");
        contentPane.add((Component)this.statusBar, "South");
        contentPane.add((Component)this.tabPane, "Center");
        this.targetEnzymeSplitPane.setOrientation(1);
        this.targetEnzymeSplitPane.setDividerSize(10);
        this.targetEnzymeSplitPane.setOneTouchExpandable(true);
        this.targetEnzymeSplitPane.setLeftComponent(this.targetPanel);
        this.targetEnzymeSplitPane.setRightComponent(this.enzymePanel);
        this.resultSplitPane.setOrientation(1);
        this.resultSplitPane.setDividerSize(10);
        this.resultSplitPane.setOneTouchExpandable(true);
        this.resultSplitPane.setLeftComponent(this.allPanel);
        this.resultSplitPane.setRightComponent(this.acceptedPanel);
        this.combinationSplitPane.setOrientation(1);
        this.combinationSplitPane.setDividerSize(10);
        this.combinationSplitPane.setLeftComponent(this.combinationAcceptedPanel);
        this.combinationSplitPane.setOneTouchExpandable(true);
        this.combinationSplitPane.setRightComponent(this.combinationSelectedPanel);
        this.targetScrollPane.getViewport().add((Component)this.targetTable, null);
        this.targetPanel.add((Component)this.targetScrollPane, "Center");
        Box targetInfoBox = new Box(1);
        targetInfoBox.add(this.targetInfoLabel1);
        targetInfoBox.add(this.targetInfoLabel2);
        this.targetPanel.add((Component)targetInfoBox, "South");
        this.enzymeScrollPane.getViewport().add((Component)this.reactionTable, null);
        this.enzymePanel.add((Component)this.enzymeScrollPane, "Center");
        Box reactionInfoBox = new Box(1);
        reactionInfoBox.add(this.reactionInfoLabel1);
        this.enzymePanel.add((Component)reactionInfoBox, "South");
        this.targetEnzymeSplitPane.add((Component)this.targetPanel, "left");
        this.targetEnzymeSplitPane.add((Component)this.enzymePanel, "right");
        this.targetEnzymeSplitPane.resetToPreferredSizes();
        this.allResultsScrollPane.getViewport().add((Component)this.allResultsTable, null);
        this.allPanel.add((Component)this.allResultsScrollPane, "Center");
        Box resultsInfoBox = new Box(1);
        resultsInfoBox.add(this.resultTableInfoLabel1);
        resultsInfoBox.add(this.resultTableInfoLabel2);
        resultsInfoBox.add(this.resultTableInfoLabel3);
        this.allPanel.add((Component)resultsInfoBox, "South");
        this.acceptedResultsScrollPane.getViewport().add((Component)this.acceptedResultsTable, null);
        this.acceptedPanel.add((Component)this.acceptedResultsScrollPane, "Center");
        Box acceptedInfoBox = new Box(1);
        acceptedInfoBox.add(this.acceptedTableInfoLabel1);
        acceptedInfoBox.add(this.acceptedTableInfoLabel2);
        acceptedInfoBox.add(this.acceptedTableInfoLabel3);
        this.acceptedPanel.add((Component)acceptedInfoBox, "South");
        this.resultSplitPane.add((Component)this.allPanel, "left");
        this.resultSplitPane.add((Component)this.acceptedPanel, "right");
        this.resultSplitPane.resetToPreferredSizes();
        this.combinationAcceptedScrollPane.setPreferredSize(new Dimension(300, 300));
        this.combinationSelectedScrollPane.setPreferredSize(new Dimension(654, 504));
        this.combinationAcceptedScrollPane.getViewport().add((Component)this.combinationAcceptedTable, null);
        this.combinationAcceptedPanel.add((Component)this.combinationAcceptedScrollPane, "Center");
        Box combinationAcceptedInfoBox = new Box(1);
        combinationAcceptedInfoBox.add(this.combinationAcceptedInfoLabel1);
        combinationAcceptedInfoBox.add(this.combinationAcceptedInfoLabel2);
        this.combinationAcceptedPanel.add((Component)combinationAcceptedInfoBox, "South");
        this.combinationSelectedScrollPane.getViewport().add((Component)this.combinationSelectedTable, null);
        this.combinationSelectedPanel.add((Component)this.combinationSelectedScrollPane, "Center");
        Box combinationSelectedInfoBox = new Box(1);
        combinationSelectedInfoBox.add(this.combinationSelectedInfoLabel1);
        combinationSelectedInfoBox.add(this.combinationSelectedInfoLabel2);
        this.combinationSelectedPanel.add((Component)combinationSelectedInfoBox, "South");
        this.combinationSplitPane.add((Component)this.combinationAcceptedPanel, "left");
        this.combinationSplitPane.add((Component)this.combinationSelectedPanel, "right");
        this.combinationSplitPane.resetToPreferredSizes();
        this.tabPane.add((Component)targetEnzymePane, "Targets & Reactions");
        this.tabPane.add((Component)resultsPane, "Cut results");
        this.tabPane.add((Component)combinationsPane, "Combinations");
        this.tabPane.setSelectedComponent(targetEnzymePane);
    }

    public Icon getIcon() {
        return null;
    }

    public Component createFunctionalityUI() {
        return this;
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PieceMakerPlugIn.class.getName(), "1.2");
        map.put(SwingWorkbenchUI.class.getName(), "1.0");
        return map;
    }

    public void setup(Platform platform) throws PlugInException {
        this.about = new AbstractUserAction("About PieceMaker", "Show information about PieceMaker"){

            public void execute() {
                PieceMakerGUI.this.showAboutDialog();
            }
        };
        this.helpActionSet = new UserAction[]{this.about};
        this.platform = platform;
        this.piecemaker = (PieceMakerPlugIn)platform.getPlugInInstance(PieceMakerPlugIn.class);
        this.workbench = (SwingWorkbenchUI)platform.getPlugInInstance(SwingWorkbenchUI.class);
        if (this.piecemaker == null) {
            throw new PlugInException("The PieceMaker plugin could not be found");
        }
        if (this.workbench == null) {
            throw new PlugInException("The Workbench could not be found");
        }
        platform.encapsulateActions((ActivePlugIn)this, (ActivePlugIn)this.piecemaker);
        ((AbstractUserAction)this.piecemaker.newProject).putValue("net.sf.apptools.ui.swing.SwingUserAction.swingicon", (Object)GUIUtils.getIcon(GUIUtils.class, (String)"icons/new.gif", (String)"New project"));
        ((AbstractUserAction)this.piecemaker.openProject).putValue("net.sf.apptools.ui.swing.SwingUserAction.swingicon", (Object)GUIUtils.getIcon(GUIUtils.class, (String)"icons/open.gif", (String)"Open project"));
        ((AbstractUserAction)this.piecemaker.saveProject).putValue("net.sf.apptools.ui.swing.SwingUserAction.swingicon", (Object)GUIUtils.getIcon(GUIUtils.class, (String)"icons/save.gif", (String)"Save project"));
        try {
            if (!AppUtils.checkJavaVersion((String)"1.4")) {
                this.workbench.sendMessage("Java version 1.4 is required for PieceMaker. Please update.", "Java version", (byte)0);
            }
            this.jbInit();
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        platform.addActionSet(new ActionSet(this.helpActionSet, "PieceMaker/Help", (ActivePlugIn)this, 1000));
        this.piecemaker.addProjectListener((ProjectChangeListener)this);
        this.piecemaker.addProjectListener((ProjectChangeListener)this.combinationModel);
        if (this.piecemaker.project != null) {
            this.piecemaker.project.addChangeListener((ProjectChangeListener)this);
            this.combinationModel.setProject(this.piecemaker.project);
        }
        this.updateModels();
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        this.piecemaker.removeProjectListener((ProjectChangeListener)this);
        this.piecemaker.removeProjectListener((ProjectChangeListener)this.combinationModel);
        if (this.piecemaker.project != null) {
            this.piecemaker.project.removeChangeListener((ProjectChangeListener)this);
            this.piecemaker.project.removeChangeListener((ProjectChangeListener)this.combinationModel);
        }
        return true;
    }

    public String getVersion() {
        return "1.0";
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.combinationModel) {
            int successes = this.combinationModel.getSuccesses();
            this.successCountField.setText(String.valueOf(successes));
        }
    }

    void setResultModels() {
        this.resultsModel.setResults(this.piecemaker.project.getAllFragmentSets(), (byte)0, false);
        this.resultsModel.fireTableDataChanged();
        this.acceptedModel.setResults(this.piecemaker.project.getAcceptedFragmentSets(), (byte)0, true);
        this.acceptedModel.fireTableDataChanged();
        this.combinationAcceptedModel.setResults(this.piecemaker.project.getAcceptedFragmentSets(), (byte)0, true);
        this.combinationAcceptedModel.fireTableDataChanged();
    }

    void resultsTable_showFragments(int row) {
        try {
            CutFragmentTableModel model = new CutFragmentTableModel();
            String title = "";
            switch (this.resultsModel.getMode()) {
                case 0: {
                    model.setFragmentSets(this.piecemaker.project.getAllFragmentSets().getReactionResults(row), this.resultsModel.getMode(), false, null);
                    title = this.piecemaker.project.getReaction(row).getName();
                    break;
                }
                case 1: {
                    model.setFragmentSets(this.piecemaker.project.getAllFragmentSets().getTargetResults(row), this.resultsModel.getMode(), false, this.piecemaker.project.getReactions().toArray(new RestrictionEnzyme[this.piecemaker.project.getReactionCount()]));
                    title = this.piecemaker.project.getTarget(row).getID();
                }
            }
            JTable table = new JTable(model);
            table.addMouseListener(new TargetCutterFrame_fragmentSetTable_mouseAdapter(table, model, this));
            JDialog d = new JDialog(GUIUtils.getParentFrame((Component)this), "Fragments for " + title, false);
            d.getContentPane().add(new JScrollPane(table));
            d.pack();
            d.setLocation((this.getSize().width - d.getSize().width) / 2, (this.getSize().height - d.getSize().height) / 2);
            d.setVisible(true);
        }
        catch (Exception ex) {
            this.platform.handleError(ex.toString(), (Throwable)ex);
        }
    }

    void acceptedTable_showFragments(int row) {
        try {
            CutFragmentTableModel model = new CutFragmentTableModel();
            String title = "";
            switch (this.acceptedModel.getMode()) {
                case 0: {
                    model.setFragmentSets(this.piecemaker.project.getAcceptedFragmentSets().getReactionResults(row), this.acceptedModel.getMode(), true, null);
                    title = this.piecemaker.project.getReaction(row).getName();
                    break;
                }
                case 1: {
                    model.setFragmentSets(this.piecemaker.project.getAcceptedFragmentSets().getTargetResults(row), this.acceptedModel.getMode(), true, this.piecemaker.project.getReactions().toArray(new RestrictionEnzyme[this.piecemaker.project.getReactionCount()]));
                    title = this.piecemaker.project.getTarget(row).getID();
                }
            }
            JTable table = new JTable(model);
            table.addMouseListener(new TargetCutterFrame_fragmentSetTable_mouseAdapter(table, model, this));
            JDialog d = new JDialog(GUIUtils.getParentFrame((Component)this), "Accepted fragments for " + title, false);
            d.getContentPane().add(new JScrollPane(table));
            d.pack();
            d.setLocation((this.getSize().width - d.getSize().width) / 2, (this.getSize().height - d.getSize().height) / 2);
            d.setVisible(true);
        }
        catch (Exception ex) {
            this.platform.handleError(ex.toString(), (Throwable)ex);
        }
    }

    void combinationAcceptedTable_showFragments(int row) {
        try {
            CutFragmentTableModel model = new CutFragmentTableModel();
            model.setFragmentSets(this.piecemaker.project.getAcceptedFragmentSets().getReactionResults(row), this.combinationAcceptedModel.getMode(), true, null);
            String title = this.piecemaker.project.getReaction(row).getName();
            JTable table = new JTable(model);
            table.addMouseListener(new TargetCutterFrame_fragmentSetTable_mouseAdapter(table, model, this));
            JDialog d = new JDialog(GUIUtils.getParentFrame((Component)this), "Accepted fragments for " + title, false);
            d.getContentPane().add(new JScrollPane(table));
            d.pack();
            d.setLocation((this.getSize().width - d.getSize().width) / 2, (this.getSize().height - d.getSize().height) / 2);
            d.setVisible(true);
        }
        catch (Exception ex) {
            this.platform.handleError(ex.toString(), (Throwable)ex);
        }
    }

    void fragmentSetTable_mouseClicked(JTable table, CutFragmentTableModel model, MouseEvent e) {
        try {
            if (e.getClickCount() == 2) {
                int row = table.rowAtPoint(e.getPoint());
                MutableFragmentSet set = model.getMutableFragmentSet(row);
                new FragmentSetDialog(GUIUtils.getParentFrame((Component)this), "Fragments", (FragmentSet)set, this.piecemaker.project, this.combinationModel, model.isAcceptedOnly()).setVisible(true);
            }
        }
        catch (Exception ex) {
            this.platform.handleError(ex.toString(), (Throwable)ex);
        }
    }

    void targetTable_mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            SelectorTarget ts = this.piecemaker.project.getTarget(this.targetTable.getSelectedRow());
            String id = ts instanceof Identifiable ? ((Identifiable)ts).getID() : String.valueOf(ts.getParentID()) + "|" + ts.getStart();
            JTextArea area = new JTextArea(25, 60);
            area.setFont(Font.getFont("monospaced", area.getFont()));
            area.setEditable(false);
            area.setLineWrap(true);
            if (ts instanceof Sequence) {
                Sequence seq = (Sequence)ts;
                area.setText(seq.seqString());
                int limit = 10000;
                if (ts.length() > limit && JOptionPane.showConfirmDialog(this, "This sequence exceeds " + limit + " bases. The system may become unresponsive if you try to show this sequence. Show it anyway?", "Show Target Sequence", 0) != 0) {
                    return;
                }
            } else {
                area.setText("No sequence data available");
            }
            JOptionPane.showMessageDialog(this, new JScrollPane(area), id, -1, null);
        }
    }

    void combinationTable_showFragments(int row, int col) {
        if (row >= 0 && col > 0 && col < this.combinationModel.getColumnCount() - 1) {
            Frame f = GUIUtils.getParentFrame((Component)this);
            new FragmentSetDialog(f, String.valueOf(this.piecemaker.project.getTarget(row).getID()) + " : " + this.piecemaker.project.getCombinationReaction(col - 1).getName(), (FragmentSet)this.piecemaker.project.getCombinationForTarget(row)[col - 1], this.piecemaker.project, this.combinationModel, true).setVisible(true);
        } else if (row >= 0 && col == this.combinationModel.getColumnCount() - 1 && this.piecemaker.project.getCombinationForTarget(row).length > 0) {
            String enzymeNames = "";
            int i = 0;
            while (i < this.piecemaker.project.getCombinationReactionCount()) {
                enzymeNames = String.valueOf(enzymeNames) + (i > 0 ? " / " : "") + this.piecemaker.project.getCombinationReaction(i).getName();
                ++i;
            }
            MutableFragmentSet[] sets = this.piecemaker.project.getCombinationForTarget(row);
            SelectorTarget target = this.piecemaker.project.getTarget(row);
            new FragmentSetDialog(GUIUtils.getParentFrame((Component)this), String.valueOf(this.piecemaker.project.getTarget(row).getID()) + " : " + enzymeNames, PieceMakerDataFactory.createPooledMutableFragmentSet((FragmentSet[])sets, (SelectorTarget)target), this.piecemaker.project, this.combinationModel, true).setVisible(true);
        }
    }

    void combinationTable_showFragmentView(int[] rows, int col) {
        String title;
        SelectorTarget[] targets = new SelectorTarget[rows.length];
        FragmentSet[] sets = new FragmentSet[rows.length];
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            targets[i] = this.piecemaker.project.getTarget(row);
            if (col == this.combinationModel.getColumnCount() - 1) {
                String enzymeNames = "";
                int r = 0;
                while (r < this.piecemaker.project.getCombinationReactionCount()) {
                    enzymeNames = String.valueOf(enzymeNames) + (r > 0 ? " / " : "") + this.piecemaker.project.getCombinationReaction(r).getName();
                    ++r;
                }
                MutableFragmentSet[] rsets = this.piecemaker.project.getCombinationForTarget(row);
                sets[i] = PieceMakerDataFactory.createPooledMutableFragmentSet((FragmentSet[])rsets, (SelectorTarget)targets[i]);
            } else if (col > 0 && col < this.combinationModel.getColumnCount() - 1) {
                sets[i] = this.piecemaker.project.getCombinationForTarget(row)[col - 1];
            }
            ++i;
        }
        if (col == this.combinationModel.getColumnCount() - 1) {
            String enzymeNames = "";
            int i2 = 0;
            while (i2 < this.piecemaker.project.getCombinationReactionCount()) {
                enzymeNames = String.valueOf(enzymeNames) + (i2 > 0 ? " / " : "") + this.piecemaker.project.getCombinationReaction(i2).getName();
                ++i2;
            }
            title = enzymeNames;
        } else if (col > 0 && col < this.combinationModel.getColumnCount() - 1) {
            title = this.piecemaker.project.getCombinationReaction(col - 1).getName();
        } else {
            return;
        }
        CoverageDialog cd = new CoverageDialog(GUIUtils.getParentFrame((Component)this), targets, sets, title);
        if (cd != null) {
            cd.setVisible(true);
        }
    }

    void updateModels() {
        if (this.piecemaker.project != null) {
            this.targetModel.setTargets(this.piecemaker.project.getTargetList());
            this.reactionModel.setReactions(this.piecemaker.project.getReactions());
            this.resultsModel.setResults(this.piecemaker.project.getAllFragmentSets(), (byte)0, false);
            this.acceptedModel.setResults(this.piecemaker.project.getAcceptedFragmentSets(), (byte)0, true);
            this.combinationAcceptedModel.setResults(this.piecemaker.project.getAcceptedFragmentSets(), (byte)0, true);
        }
    }

    void enzymeTable_keyReleased(KeyEvent e) {
        int[] rows = this.reactionTable.getSelectedRows();
        Arrays.sort(rows);
        if (e.getKeyCode() == 127) {
            int i = rows.length - 1;
            while (i >= 0) {
                this.piecemaker.removeReaction(rows[i]);
                --i;
            }
        }
    }

    void targetTable_keyReleased(KeyEvent e) {
        int[] rows = this.targetTable.getSelectedRows();
        Arrays.sort(rows);
        if (e.getKeyCode() == 127) {
            int i = rows.length - 1;
            while (i >= 0) {
                this.piecemaker.removeTarget(rows[i]);
                --i;
            }
        }
    }

    public void showAboutDialog() {
        PieceMaker_AboutBox dlg = new PieceMaker_AboutBox(GUIUtils.getParentFrame((Component)this));
        GUIUtils.checkSize((JDialog)dlg);
        dlg.setLocation(GUIUtils.suggestLocation((Window)dlg, (Frame)GUIUtils.getParentFrame((Component)this)));
        dlg.setVisible(true);
    }

    public void projectChanged(ProjectChangeEvent e) {
        if (e.getEventType() == ProjectChangeEvent.ALL_CHANGED || e.getEventType() == ProjectChangeEvent.TARGETS_CHANGED) {
            this.targetModel.setTargets(((PieceMakerProject)e.getSource()).getTargetList());
        }
        if (e.getEventType() == ProjectChangeEvent.ALL_CHANGED || e.getEventType() == ProjectChangeEvent.REACTIONS_CHANGED) {
            this.reactionModel.setReactions(((PieceMakerProject)e.getSource()).getReactions());
        }
        if (e.getEventType() == ProjectChangeEvent.ALL_CHANGED || e.getEventType() == ProjectChangeEvent.RESULTS_CHANGED) {
            this.setResultModels();
        }
    }

    public void projectOpened(PieceMakerProject newProject) {
        newProject.addChangeListener((ProjectChangeListener)this);
        this.updateModels();
    }

    public void projectClosing(PieceMakerProject oldProject) {
        oldProject.removeChangeListener((ProjectChangeListener)this);
    }
}

