/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import net.sf.apptools.plugin.PlugInUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PlugInFileWriter {
    public void storePlugInLists(Collection<Class<?>>[] var1, String[] var2, OutputStream var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLInfoFileWriter
    implements PlugInFileWriter {
        static final String xmlString = "<?xml version=\"1.0\"?>";
        static final String dtdString = "<!DOCTYPE EXTENSION_LIST [\n <!ELEMENT EXTENSION_LIST    (EXTENSION*)>\n <!ELEMENT EXTENSION     (TYPE,TITLE,CLASSNAME,DESCRIPTION,AUTHOR,COMMENTS)>\n <!ELEMENT TYPE          (#PCDATA)>\n <!ELEMENT TITLE         (#PCDATA)>\n <!ELEMENT CLASSNAME     (#PCDATA)>\n <!ELEMENT DESCRIPTION       (#PCDATA)>\n <!ELEMENT AUTHOR        (#PCDATA)>\n <!ELEMENT COMMENTS      (#PCDATA)>\n]>\n";

        static String tag(String body, String tag) {
            return "<" + tag + ">" + body + "</" + tag + ">";
        }

        @Override
        public void storePlugInLists(Collection<Class<?>>[] classes, String[] descriptions, OutputStream out) {
            PrintStream pout = new PrintStream(out);
            pout.println(xmlString);
            pout.println(dtdString);
            pout.println("<EXTENSION_LIST>");
            for (int i = 0; i < classes.length; ++i) {
                for (Class<?> pc : classes[i]) {
                    try {
                        String longDesc = PlugInUtils.getLongDescription(pc);
                        String name = PlugInUtils.getBriefDescription(pc);
                        pout.println("<EXTENSION>");
                        pout.println(XMLInfoFileWriter.tag(i < descriptions.length ? descriptions[i] : "UNKNOWN", "TYPE"));
                        pout.println(XMLInfoFileWriter.tag(name, "TITLE"));
                        pout.println(XMLInfoFileWriter.tag(pc.getName(), "CLASSNAME"));
                        pout.println(XMLInfoFileWriter.tag("<![CDATA[" + longDesc + "]]>", "DESCRIPTION"));
                        pout.println(XMLInfoFileWriter.tag("Johan Stenberg", "AUTHOR"));
                        pout.println(XMLInfoFileWriter.tag("This extension is included in the ProbeMaker package", "COMMENTS"));
                        pout.println("</EXTENSION>");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            pout.println("</EXTENSION_LIST>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultFileWriter
    implements PlugInFileWriter {
        @Override
        public void storePlugInLists(Collection<Class<?>>[] classes, String[] descriptions, OutputStream out) {
            PrintStream pout = new PrintStream(out);
            for (int i = 0; i < classes.length; ++i) {
                if (i < descriptions.length) {
                    pout.println("#" + descriptions[i]);
                } else {
                    pout.println("#UNKNOWN");
                }
                for (Class<?> c : classes[i]) {
                    pout.println(c.getName());
                }
            }
        }
    }
}

