/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import net.genefront.piecemaker.gui.DisplayContext;
import net.genefront.piecemaker.gui.SequenceLineRenderer;
import org.moltools.lib.seq.Region;

public class ScaleRenderer
implements SequenceLineRenderer {
    protected boolean ticks;
    protected int tickHeight;
    protected int tickCount;
    protected boolean labels;
    protected Font font;
    protected Color color;
    int[] spacings = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000, 5000000, 10000000, 20000000, 50000000, 100000000};

    public ScaleRenderer(boolean ticks, int tickHeight, int tickCount, boolean labels, Font font, Color color) {
        this.ticks = ticks;
        this.tickHeight = tickHeight;
        this.tickCount = tickCount;
        this.labels = labels;
        this.font = font;
        this.color = color;
    }

    public int getHeight(DisplayContext dc, Object obj) {
        return 3 + (this.ticks ? this.tickHeight : 0) + (this.labels ? this.font.getSize() + 1 : 0);
    }

    public int getRequestedHead(DisplayContext dc, Object obj) {
        return 0;
    }

    public int getRequestedTail(DisplayContext dc, Object obj) {
        return 0;
    }

    public void paint(Graphics g, DisplayContext dc, Object obj) {
        Color old = g.getColor();
        g.setColor(this.color);
        int scaleY = 1 + (this.labels ? this.font.getSize() + 1 : 0);
        int fontY = scaleY - 1;
        int x1 = dc.getPixel(dc.getDisplayedRegion().getStart());
        int x2 = dc.getPixel(dc.getDisplayedRegion().getEnd());
        g.drawLine(x1, scaleY, x2, scaleY);
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        Font oldFont = g.getFont();
        g.setFont(this.font);
        int tickSpacing = this.calculateTickSpacing(dc.getDisplayedRegion(), this.tickCount);
        int tickStart = tickSpacing * (dc.getDisplayedRegion().getStart() / tickSpacing);
        int tickEnd = tickSpacing * (dc.getDisplayedRegion().getEnd() / tickSpacing);
        int i = tickStart;
        while (i <= tickEnd) {
            int tickPos = dc.getPixel(i);
            if (this.ticks) {
                g.drawLine(tickPos, scaleY, tickPos, scaleY + this.tickHeight);
            }
            if (this.labels) {
                String label = String.valueOf(i);
                Rectangle2D r = this.font.getStringBounds(label, frc);
                g.drawString(String.valueOf(i), (int)((double)tickPos - r.getWidth() / 2.0), fontY);
            }
            i += tickSpacing;
        }
        g.setFont(oldFont);
        g.setColor(old);
    }

    protected int calculateTickSpacing(Region displayedRegion, int tickCount) {
        float prefspacing = (float)displayedRegion.length() / (float)tickCount;
        int i = this.spacings.length;
        while ((float)this.spacings[--i] > prefspacing && i > 0) {
        }
        return this.spacings[i];
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setLabels(boolean labels) {
        this.labels = labels;
    }

    public void setTickHeight(int tickHeight) {
        this.tickHeight = tickHeight;
    }

    public void setTicks(boolean ticks) {
        this.ticks = ticks;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }
}

