/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.List;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.Named;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.ChangeableSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;
import org.moltools.workbench.DataFlavors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTableDropTargetListener
extends DropTargetAdapter {
    protected ChangeableSequenceDB<Sequence> db;

    public SequenceTableDropTargetListener(ChangeableSequenceDB<? extends Sequence> db) {
        this.db = new ListSequenceDB(db);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor flavor;
        List<DataFlavor> flavorList = dtde.getCurrentDataFlavorsAsList();
        if (flavorList.contains(flavor = DataFlavors.SequenceDBFlavor)) {
            try {
                dtde.acceptDrop(1);
                DefiniteSequenceDB transferdb = (DefiniteSequenceDB)dtde.getTransferable().getTransferData(flavor);
                for (Sequence s : transferdb) {
                    String name = "";
                    if (s instanceof Named) {
                        name = ((Named)s).getName();
                    }
                    if (s instanceof NucleotideSequence) {
                        NucleotideSequence ns = (NucleotideSequence)s;
                        SimpleChangeableNucleotideSequence sadd = new SimpleChangeableNucleotideSequence(ns.getID(), ns.seqString(), ns.getType(), name);
                        this.db.addSequence((Sequence)sadd);
                        continue;
                    }
                    throw new IllegalArgumentException("Only nucleotide sequences are supported in drag and drop");
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DuplicateIDException e) {
                throw new RuntimeException(e);
            }
        } else {
            dtde.rejectDrop();
        }
    }
}

