/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.genefront.piecemaker.gui.DisplayContext;
import net.genefront.piecemaker.gui.SequenceLineRenderer;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.impl.SimpleRegion;

public class MultiLineDisplay
extends JPanel
implements DisplayContext {
    protected Region range;
    protected float scale = 1.0f;
    protected List<Object> objects = new ArrayList<Object>();
    protected List<SequenceLineRenderer> renderers = new ArrayList<SequenceLineRenderer>();
    int head = 10;
    int tail = 10;
    int top = 10;
    int bottom = 10;
    private boolean drawLimits;
    private int limit1;
    private int limit2;

    public MultiLineDisplay() {
        this.range = new SimpleRegion(1, 100);
    }

    public void addLine(Object obj, SequenceLineRenderer renderer) {
        this.objects.add(obj);
        this.renderers.add(renderer);
    }

    public void addLine(int i, Object obj, SequenceLineRenderer renderer) {
        this.objects.add(i, obj);
        this.renderers.add(i, renderer);
    }

    public void removeLine(int i) {
        this.objects.remove(i);
        this.renderers.remove(i);
    }

    public void removeAllLines() {
        this.objects.clear();
        this.renderers.clear();
    }

    public void set(Region range, float scale) {
        this.range = range;
        this.scale = scale;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int height = this.top + this.bottom;
        int i = 0;
        while (i < this.objects.size()) {
            Object obj = this.objects.get(i);
            SequenceLineRenderer r = this.renderers.get(i);
            height += r.getHeight(this, obj);
            int h = r.getRequestedHead(this, obj);
            int t = r.getRequestedTail(this, obj);
            if (h > this.head) {
                this.head = h;
            }
            if (t > this.tail) {
                this.tail = t;
            }
            ++i;
        }
        return new Dimension(d.width, height);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform at = g2.getTransform();
        int i = 0;
        while (i < this.objects.size()) {
            Object obj = this.objects.get(i);
            SequenceLineRenderer r = this.renderers.get(i);
            r.paint(g, this, obj);
            int dy = r.getHeight(this, obj);
            g2.translate(0, dy);
            ++i;
        }
        g2.setTransform(at);
        if (this.drawLimits) {
            g2.drawLine(this.limit1, 0, this.limit1, this.getHeight());
            g2.drawLine(this.limit2, 0, this.limit2, this.getHeight());
        }
    }

    public Region getDisplayedRegion() {
        return this.range;
    }

    public float getScale() {
        return this.scale;
    }

    public int getPixel(int position) {
        int offset = position - this.range.getStart();
        return this.head + Math.round((float)offset / this.scale);
    }

    public void setScale(float scale) {
        this.set(this.range, scale);
    }

    public int getPosition(int pixel) {
        int pixpos = pixel - this.head;
        return (int)((float)pixpos * this.scale + (float)this.range.getStart());
    }

    public void unsetLimits() {
        this.drawLimits = false;
    }

    public void setLimits(int startx, int lastx) {
        this.drawLimits = true;
        this.limit1 = startx;
        this.limit2 = lastx;
    }
}

